/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.render.MeteorlogicalUtil;
import ivorius.psychedelicraft.client.render.PsycheMatrixHelper;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.stream.IntStream;
import net.minecraft.class_1041;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import org.joml.Vector3f;

public class LensFlareScreenEffect
implements ScreenEffect {
    private static final float[] FLARE_SIZES = new float[]{0.15f, 0.24f, 0.12f, 0.036f, 0.06f, 0.048f, 0.006f, 0.012f, 0.5f, 0.09f, 0.036f, 0.09f, 0.06f, 0.05f, 0.6f};
    private static final float[] FLARE_INFLUENCES = new float[]{-1.3f, -2.0f, 0.2f, 0.4f, 0.25f, -0.25f, -0.7f, -1.0f, 1.0f, 1.4f, -1.31f, -1.2f, -1.5f, -1.55f, -3.0f};
    private static final class_2960[] FLARES = (class_2960[])IntStream.range(0, FLARE_SIZES.length).mapToObj(i -> Psychedelicraft.id("textures/environment/lense_flare/flare" + i + ".png")).toArray(class_2960[]::new);
    private static final class_2960 BLINDNESS_OVERLAY = Psychedelicraft.id("textures/environment/lense_flare/sun_blindness.png");
    private float actualSunAlpha = 0.0f;
    private final class_310 client = class_310.method_1551();

    @Override
    public boolean shouldApply(float ticks) {
        return this.getIntensity() > 0.0f;
    }

    @Override
    public void update(float tickDelta) {
        this.actualSunAlpha = Math.min(1.0f, MathUtils.nearValue(this.actualSunAlpha, MeteorlogicalUtil.getSunFlareIntensity((class_1937)this.client.field_1687, this.client.method_1560(), tickDelta), 0.1f, 0.01f));
    }

    protected float getIntensity() {
        return ((Float)PsychedelicraftClient.getConfig().sunFlareIntensity.get()).floatValue();
    }

    @Override
    public void render(class_332 context, class_1041 window, float tickDelta) {
        int screenHeight;
        if (this.actualSunAlpha <= 0.0f) {
            return;
        }
        class_638 world = this.client.field_1687;
        if (world == null) {
            return;
        }
        int screenWidth = window.method_4486();
        float genSize = screenWidth > (screenHeight = window.method_4502()) ? (float)screenWidth : (float)screenHeight;
        float sunRadians = world.method_8442(tickDelta);
        Vector3f sunPositionOnScreen = PsycheMatrixHelper.projectPointCurrentView(PsycheMatrixHelper.fromPolar(sunRadians, 120.0f));
        Vector3f normSunPos = sunPositionOnScreen.normalize(new Vector3f());
        if (sunPositionOnScreen.z > 0.0f) {
            return;
        }
        float xDist = normSunPos.x * (float)screenWidth;
        float yDist = normSunPos.y * (float)screenHeight;
        int colorValue = ((class_1959)world.method_23753(this.client.field_1773.method_19418().method_19328()).comp_349()).method_24376();
        int fogRed = class_9848.method_61327((int)colorValue);
        int fogGreen = class_9848.method_61329((int)colorValue);
        int fogBlue = class_9848.method_61331((int)colorValue);
        float alpha = Math.min(1.0f, sunPositionOnScreen.z);
        float screenCenterX = (float)screenWidth * 0.5f;
        float screenCenterY = (float)screenHeight * 0.5f;
        for (int i = 0; i < FLARE_SIZES.length; ++i) {
            float flareSizeHalf = FLARE_SIZES[i] * genSize * 0.5f;
            float flareCenterX = screenCenterX + xDist * FLARE_INFLUENCES[i];
            float flareCenterY = screenCenterY + yDist * FLARE_INFLUENCES[i];
            RenderSystem.setShaderColor((float)((float)fogRed - 0.1f), (float)((float)fogGreen - 0.1f), (float)((float)fogBlue - 0.1f), (float)((alpha * (float)i == 8.0f ? 1.0f : 0.5f) * this.actualSunAlpha * this.getIntensity()));
            RenderUtil.drawQuad(context, FLARES[i], flareCenterX - flareSizeHalf, flareCenterY - flareSizeHalf, flareCenterX + flareSizeHalf, flareCenterY + flareSizeHalf);
        }
        float genDist = 1.0f - (normSunPos.x * normSunPos.x + normSunPos.y * normSunPos.y);
        float blendingSize = (genDist - 0.1f) * this.getIntensity() * 250.0f * genSize;
        if (blendingSize > 0.0f) {
            float blendingSizeHalf = blendingSize * 0.5f;
            float blendCenterX = screenCenterX + xDist;
            float blendCenterY = screenCenterY + yDist;
            float blendAlpha = Math.min(1.0f, blendingSize / genSize / 150.0f);
            RenderSystem.setShaderColor((float)((float)fogRed - 0.1f), (float)((float)fogGreen - 0.1f), (float)((float)fogBlue - 0.1f), (float)(blendAlpha * this.actualSunAlpha));
            RenderUtil.drawQuad(context, BLINDNESS_OVERLAY, blendCenterX - blendingSizeHalf, blendCenterY - blendingSizeHalf, blendCenterX + blendingSizeHalf, blendCenterY + blendingSizeHalf);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void close() {
    }
}

