/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1657;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class MotionBlurScreenEffect
implements ScreenEffect {
    private static final int MAX_SAMPLES = 30;
    private static final float SAMPLE_FREQUENCY = 0.5f;
    private float previousTicks;
    private int currentSample;
    private GlTextureSet textures;
    public float motionBlur;

    @Override
    public void update(float tickDelta) {
        this.motionBlur = (Boolean)PsychedelicraftClient.getConfig().doMotionBlur.get() != false && class_310.method_1551().field_1724 != null ? DrugProperties.of((class_1657)class_310.method_1551().field_1724).getModifier(Drug.MOTION_BLUR) : 0.0f;
    }

    @Override
    public void render(class_332 context, class_1041 window, float tickDelta) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        if (this.motionBlur > 0.0f) {
            if (this.textures != null && this.textures.sizeChanged(screenWidth, screenHeight)) {
                this.close();
            }
            if (this.textures == null) {
                this.textures = new GlTextureSet(30, screenWidth, screenHeight);
            }
            if (this.previousTicks > (tickDelta += (float)class_310.method_1551().field_1724.field_6012)) {
                this.previousTicks = tickDelta;
            } else if (this.previousTicks + 15.0f < tickDelta) {
                this.previousTicks = tickDelta - 15.0f;
            }
            while (this.previousTicks + 0.5f <= tickDelta) {
                ++this.currentSample;
                this.currentSample %= 30;
                this.textures.getTexture(this.currentSample).sample();
                this.previousTicks += 0.5f;
            }
            this.textures.drawToScreen(context, this.currentSample);
        } else if (this.textures != null) {
            ++this.currentSample;
            this.currentSample %= 30;
            this.textures.getTexture(this.currentSample).reset();
        }
    }

    @Override
    public void close() {
        if (this.textures != null) {
            this.textures.close();
            this.textures = null;
        }
    }

    private class GlTextureSet
    implements AutoCloseable {
        private final int width;
        private final int height;
        private final List<GlTexture> textures;

        public GlTextureSet(int samples, int width, int height) {
            this.width = width;
            this.height = height;
            this.textures = IntStream.range(1, samples + 1).mapToObj(i -> new GlTexture(Psychedelicraft.id("motion_blur_" + i), i)).toList();
        }

        public GlTexture getTexture(int sample) {
            return this.textures.get(sample);
        }

        public boolean sizeChanged(int width, int height) {
            return this.width != width || this.height != height;
        }

        public void drawToScreen(class_332 context, int currentSample) {
            for (int i = 0; i < this.textures.size(); ++i) {
                this.textures.get((i + currentSample) % this.textures.size()).drawToScreen(context);
            }
        }

        @Override
        public void close() {
            this.textures.forEach(texture -> class_310.method_1551().method_1531().method_4615(texture.id));
        }
    }

    private class GlTexture
    extends class_1044
    implements AutoCloseable {
        private final class_2960 id;
        private final int sample;
        private int width;
        private int height;
        private boolean prepared;

        public GlTexture(class_2960 id, int sample) {
            this.id = id;
            this.sample = sample;
            class_310.method_1551().method_1531().method_4616(id, (class_1044)this);
        }

        public void sample() {
            class_276 input = class_310.method_1551().method_1522();
            if (this.width != input.field_1482 || this.height != input.field_1481) {
                this.close();
                this.width = input.field_1482;
                this.height = input.field_1481;
            }
            if (this.field_56974 == null || this.field_56974.isClosed()) {
                this.field_56974 = RenderSystem.getDevice().createTexture(() -> "PS_MotionBlurFrame" + this.sample + this.hashCode(), TextureFormat.RGBA8, input.field_1482, input.field_1481, 1);
                this.width = input.field_1482;
                this.height = input.field_1481;
            }
            CommandEncoder inCommand = RenderSystem.getDevice().createCommandEncoder();
            inCommand.copyTextureToTexture(input.method_30277(), this.field_56974, 0, 0, 0, 0, 0, input.field_1482, input.field_1481);
            inCommand.copyTextureToTexture(input.method_30277(), this.field_56974, 0, 0, 0, 0, 0, input.field_1482, input.field_1481);
            this.prepared = true;
        }

        public void reset() {
            this.prepared = false;
            this.field_56974.close();
        }

        public void drawToScreen(class_332 context) {
            float alpha = Math.min(1.0f, (float)this.sample * 0.008f * MotionBlurScreenEffect.this.motionBlur);
            if (this.prepared && alpha > 0.0f) {
                RenderUtil.drawTexture(context, this.id, this.width, this.height, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }
}

