/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.effect.DrugOverlayScreenEffect;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.type.PowerDrug;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_9848;

public class PowerOverlayScreenEffect
extends DrugOverlayScreenEffect<PowerDrug> {
    private static final class_2960 POWER_PARTICLE_TEXTURE = Psychedelicraft.id("textures/drug/power/particle.png");
    private static final class_2960[] LIGHTNING_TEXTURES = (class_2960[])IntStream.range(0, 4).mapToObj(i -> Psychedelicraft.id("textures/drug/power/lightning_" + i + ".png")).toArray(class_2960[]::new);

    public PowerOverlayScreenEffect() {
        super(DrugType.POWER);
    }

    @Override
    protected void render(class_332 context, class_1041 window, float tickDelta, DrugProperties properties, PowerDrug drug) {
        int powerLightnings;
        class_1657 entity = properties.asEntity();
        int width = window.method_4486();
        int height = window.method_4502();
        float power = (float)drug.getActiveValue();
        Random powerR = new Random(entity.field_6012);
        int powerParticles = class_3532.method_15375((float)(powerR.nextFloat() * 200.0f * power));
        if (powerParticles > 0) {
            this.renderRandomParticles(context, powerParticles, width / 10, class_3532.method_15386((float)((float)(height / 10) * power)), width, height, powerR);
        }
        Random powerLR = new Random((long)(entity.field_6012 / 2) * 21124871824L);
        float lightningChance = (power - 0.5f) * 0.1f;
        for (powerLightnings = 0; powerLR.nextFloat() < lightningChance && powerLightnings < 3; ++powerLightnings) {
        }
        if (powerLightnings > 0) {
            int lightningW = height;
            class_4597.class_4598 vertices = class_310.method_1551().method_22940().method_23000();
            for (int i = 0; i < powerLightnings; ++i) {
                float lX = powerLR.nextInt(width + lightningW) - lightningW;
                lX += (powerLR.nextFloat() - 0.5f) * (float)lightningW * tickDelta * 2.0f;
                int lIndex = powerLR.nextInt(LIGHTNING_TEXTURES.length);
                boolean upsideDown = powerLR.nextBoolean();
                float lightningTime = ((float)(entity.field_6012 % 2) + tickDelta) * 0.5f;
                int color = class_9848.method_61330((int)class_9848.method_61326((float)((0.05f + power * 0.1f) * (1.0f - lightningTime))), (int)-1);
                class_1921 layer = class_1921.method_62275((class_2960)LIGHTNING_TEXTURES[lIndex]);
                class_4588 buffer = vertices.getBuffer(layer);
                buffer.method_22912(lX, (float)height, -90.0f).method_22913(0.0f, upsideDown ? 0.0f : 1.0f).method_39415(color).method_22912(lX + (float)lightningW, (float)height, -90.0f).method_22913(1.0f, upsideDown ? 0.0f : 1.0f).method_39415(color).method_22912(lX + (float)lightningW, 0.0f, -90.0f).method_22913(1.0f, upsideDown ? 1.0f : 0.0f).method_39415(color).method_22912(lX, 0.0f, -90.0f).method_22913(0.0f, upsideDown ? 1.0f : 0.0f).method_39415(color);
                vertices.method_22994(layer);
            }
        }
    }

    private void renderRandomParticles(class_332 context, int number, int width, int height, int screenWidth, int screenHeight, Random rand) {
        for (int i = 0; i < number; ++i) {
            int x = rand.nextInt(screenWidth + width) - width;
            int y = rand.nextInt(screenHeight + height) - height;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.drawQuad(context, POWER_PARTICLE_TEXTURE, x, y, x + width, y + height);
        }
    }
}

