/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_10868;
import net.minecraft.class_284;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;

public class BuiltGemoetryShader {
    private final int program;
    private final List<class_284> uniforms;
    private final List<Sampler> samplers;

    public BuiltGemoetryShader(int program, List<class_284> uniforms, List<Sampler> samplers) {
        this.program = program;
        this.uniforms = uniforms;
        this.samplers = samplers;
    }

    public void bind() {
        for (Sampler sampler : this.samplers) {
            sampler.bind(this.program);
        }
        for (class_284 uniform : this.uniforms) {
            uniform.method_1300();
        }
    }

    private static class Sampler {
        private final int id;
        public int location;
        private final String name;
        private final Supplier<GpuTexture> valueGetter;

        public Sampler(int id, String name, Supplier<GpuTexture> valueGetter) {
            this.id = id;
            this.name = name;
            this.valueGetter = valueGetter;
        }

        void bind(int program) {
            class_10868 texId = (class_10868)this.valueGetter.get();
            class_284.method_22095((int)this.location, (int)this.id);
            GlStateManager._activeTexture((int)(33984 + this.id));
            GlStateManager._bindTexture((int)texId.method_68427());
            texId.method_68424();
        }
    }

    public static class Builder {
        private final List<class_284> uniforms = new ArrayList<class_284>();
        private final List<Sampler> samplers = new ArrayList<Sampler>();
        private final int program;
        private int lastFragmentId;

        public Builder(int program, int lastAttributeId, int lastFragmentId) {
            this.program = program;
            this.lastFragmentId = lastFragmentId;
        }

        void addSampler(String sampler, Supplier<GpuTexture> supplier) {
            this.samplers.add(new Sampler(++this.lastFragmentId, sampler, supplier));
        }

        void addUniform(class_284 uniform) {
            this.uniforms.add(uniform);
        }

        public BuiltGemoetryShader build() {
            ArrayList<Sampler> samplers = new ArrayList<Sampler>();
            this.samplers.forEach(sampler -> {
                int location = GL20C.glGetUniformLocation((int)this.program, (CharSequence)sampler.name);
                if (location != -1) {
                    sampler.location = location;
                    samplers.add((Sampler)sampler);
                }
            });
            ArrayList<class_284> uniforms = new ArrayList<class_284>();
            this.uniforms.forEach(uniform -> {
                int location = GL20C.glGetUniformLocation((int)this.program, (CharSequence)uniform.method_1298());
                if (location != -1) {
                    uniforms.add((class_284)uniform);
                    uniform.method_1297(location);
                }
            });
            return new BuiltGemoetryShader(this.program, uniforms, samplers);
        }
    }

    public static interface Holder {
        public void attachUniformData(@Nullable BuiltGemoetryShader var1);
    }
}

