/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.google.gson.JsonSyntaxException;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.render.shader.PostEffectPassSupplier;
import ivorius.psychedelicraft.client.render.shader.UniformBinding;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_9920;
import net.minecraft.class_9922;
import net.minecraft.class_9960;
import net.minecraft.class_9962;

class LoadedShader {
    private final class_2960 id;
    private final class_310 client;
    private final UniformBinding.Set bindings;
    private final List<Pass> passes = new ArrayList<Pass>();
    private int passCount = 0;

    public LoadedShader(class_310 client, class_2960 id, UniformBinding.Set bindings) throws IOException, JsonSyntaxException {
        this.client = client;
        this.id = id;
        this.bindings = bindings;
    }

    public void render(class_9920 pool, float tickDelta) {
        try {
            class_279 processor = this.client.method_62887().method_62941(this.id, class_9960.field_53902);
            if (processor == null) {
                return;
            }
            this.passCount = 0;
            this.passes.clear();
            HashMap passById = new HashMap();
            this.update(this.client, processor, tickDelta, (id, callback) -> {
                this.passCount = Math.max(this.passCount, passById.computeIfAbsent(id, this::addPass).add((Runnable)callback));
            });
            for (int i = 0; i < this.passCount; ++i) {
                for (Pass pass : this.passes) {
                    pass.replay(i);
                }
                processor.method_1258(this.client.method_1522(), (class_9922)pool, null);
            }
        }
        catch (Throwable t) {
            Psychedelicraft.LOGGER.error("Exception applying shader pass: {}", t);
        }
    }

    private Pass addPass(String id) {
        Pass pass = new Pass(new ArrayList<Runnable>());
        this.passes.add(pass);
        return pass;
    }

    public void update(class_310 client, class_279 processor, float tickDelta, BiConsumer<String, Runnable> passCollector) {
        int width = client.method_22683().method_4489();
        int height = client.method_22683().method_4506();
        PassState globalState = new PassState(new HashMap<String, class_9962.class_9970>());
        this.bindings.global.bindUniforms(globalState, tickDelta, width, height, () -> {
            for (PostEffectPassSupplier.Pass pass : ((PostEffectPassSupplier)processor).getPasses()) {
                String passId = pass.getId();
                UniformBinding programBindings = this.bindings.programBindings.getOrDefault(class_2960.method_60654((String)passId).method_45138("post/"), UniformBinding.EMPTY);
                if (programBindings == UniformBinding.EMPTY) continue;
                pass.setDisabled();
                PassState state = new PassState(new HashMap<String, class_9962.class_9970>(globalState.uniforms));
                programBindings.bindUniforms(state, tickDelta, width, height, () -> passCollector.accept(passId, () -> pass.setUniformUpdater(pipeline -> state.bind())));
            }
        });
    }

    record Pass(List<Runnable> callbacks) {
        int add(Runnable callback) {
            this.callbacks.add(callback);
            return this.callbacks.size();
        }

        void replay(int pass) {
            if (pass >= 0 && pass < this.callbacks.size()) {
                this.callbacks.get(pass).run();
            }
        }
    }

    record PassState(Map<String, class_9962.class_9970> uniforms) implements UniformBinding.UniformSetter
    {
        @Override
        public void set(String name, String type, Supplier<List<Float>> setter) {
            this.uniforms.put(name, new class_9962.class_9970(name, type, Optional.of(setter.get())));
        }

        List<class_9962.class_9970> bind() {
            ArrayList<class_9962.class_9970> uniforms = new ArrayList<class_9962.class_9970>();
            uniforms.addAll(this.uniforms().values());
            return uniforms;
        }
    }
}

