/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.joml.Vector3fc;
import org.joml.Vector4fc;

public interface UniformBinding {
    public static final UniformBinding EMPTY = (uniforms, tickDelta, screenWidth, screenHeight, pass) -> pass.run();

    public void bindUniforms(UniformSetter var1, float var2, int var3, int var4, Runnable var5);

    public static Set start() {
        return new Set();
    }

    public static final class Set {
        UniformBinding global = EMPTY;
        final Map<class_2960, UniformBinding> programBindings = new HashMap<class_2960, UniformBinding>();

        public Set bind(UniformBinding all) {
            this.global = all;
            return this;
        }

        public Set program(class_2960 programName, UniformBinding binding) {
            this.programBindings.put(programName.method_45138("post/"), binding);
            return this;
        }
    }

    public static interface UniformSetter {
        public void set(String var1, String var2, Supplier<List<Float>> var3);

        default public void set(String name, float value) {
            this.set(name, "float", (Supplier<List<Float>>)Suppliers.ofInstance(List.of(Float.valueOf(value))));
        }

        default public void set(String name, float ... values) {
            this.set(name, switch (values.length) {
                case 1 -> "float";
                case 2 -> "vec2";
                case 3 -> "vec3";
                case 4 -> "vec4";
                case 16 -> "matrix4x4";
                default -> throw new IllegalArgumentException("Wrong number of arguments. Expected 1,2,3,4 or 16 but got" + values.length);
            }, (Supplier<List<Float>>)Suppliers.ofInstance((Object)FloatList.of((float[])values)));
        }

        default public void set(String name, Vector3fc values) {
            this.set(name, "vec3", (Supplier<List<Float>>)Suppliers.ofInstance(List.of(Float.valueOf(values.x()), Float.valueOf(values.y()), Float.valueOf(values.z()))));
        }

        default public void set(String name, Vector4fc values) {
            this.set(name, "vec4", (Supplier<List<Float>>)Suppliers.ofInstance(List.of(Float.valueOf(values.x()), Float.valueOf(values.y()), Float.valueOf(values.z()), Float.valueOf(values.w()))));
        }

        default public boolean setIfNonZero(String name, float value) {
            this.set(name, value);
            return value > 0.0f;
        }
    }
}

