/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import ivorius.psychedelicraft.entity.drug.Attribute;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import java.util.HashMap;
import java.util.Map;

public interface AttributeFunction {
    public static final AttributeFunction DEFAULT = (a, m) -> a.get(m.getProperties());
    public static final AttributeFunction FUNCTIONS = new Impl(new HashMap<Attribute, AttributeFunction>()).add(Drug.BLOOM_HALLUCINATION_STRENGTH, 101).add(Drug.SUPER_SATURATION_HALLUCINATION_STRENGTH, 2).add(Drug.DESATURATION_HALLUCINATION_STRENGTH, 1).add(Drug.FAST_COLOR_ROTATION, 4).add(Drug.SLOW_COLOR_ROTATION, 3).add(Drug.DISTANT_WAVES, 10).add(Drug.WIGGLE_WAVES, 7, 0.7f).add(Drug.SMALL_WAVES, 6, 0.5f).add(Drug.BIG_WAVES, 5, 0.6f).add(Drug.FRACTALS, 9);

    public float get(Attribute var1, HallucinationManager var2);

    public record Impl(Map<Attribute, AttributeFunction> functions) implements AttributeFunction
    {
        public Impl add(Attribute attribute, AttributeFunction function) {
            this.functions.put(attribute, function);
            return this;
        }

        public Impl add(Attribute attribute, int hallucinationType) {
            return this.add(attribute, hallucinationType, 1.0f);
        }

        public Impl add(Attribute attribute, int hallucinationType, float multiplier) {
            return this.add(attribute, (p, manager) -> p.get(manager.getVisualisations().getMultiplier(hallucinationType) * multiplier, manager.getProperties()));
        }

        @Override
        public float get(Attribute attribute, HallucinationManager manager) {
            return this.functions.getOrDefault(attribute, DEFAULT).get(attribute, manager);
        }
    }
}

