/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationManager;
import ivorius.psychedelicraft.entity.drug.hallucination.Personality;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class ChatBot {
    private final Personality personality;
    private final class_1657 player;
    private final List<Character> characters = new ArrayList<Character>();
    private final Queue<Runnable> incomingMessageQueue = new LinkedList<Runnable>();

    public ChatBot(Personality personality, class_1657 player) {
        this.personality = personality;
        this.player = player;
    }

    public void tick() {
        Runnable action;
        if (!this.player.method_37908().field_9236) {
            return;
        }
        if (this.characters.size() < 3 && this.player.method_59922().method_43048(200) == 0) {
            this.characters.add(new Character());
        }
        while ((action = this.incomingMessageQueue.poll()) != null) {
            action.run();
        }
        this.characters.removeIf(Character::tick);
    }

    private void emitMessage(String sender, class_2561 message) {
        HallucinationManager hallucinations = DrugProperties.of(this.player).getHallucinations();
        if (hallucinations.getEntities().getForcedAlpha(1.0f) > 0.0f || hallucinations.getEntityHallucinationStrength() > 0.0f) {
            this.player.method_7353(message, false);
            this.incomingMessageQueue.add(() -> this.getResponsiveCharacters(sender, message).forEach(character -> character.wakeUp(sender, message, false)));
            if (this.player.method_37908().method_8409().method_43057() < 0.3f || message.getString().contains("!")) {
                float x = this.player.method_37908().method_8409().method_43057();
                float z = this.player.method_37908().method_8409().method_43057();
                this.player.method_5879((float)(class_3532.method_15349((double)z, (double)x) * 57.2957763671875 - (double)this.player.method_36454()));
                this.player.method_5783(class_3417.field_15115, 1.0f, 1.0f);
                this.player.method_6005((double)0.2f, (double)x, (double)z);
            }
        }
    }

    public void onMessageReceived(String sender, class_2561 message) {
        this.getResponsiveCharacters(sender, message).forEach(character -> character.wakeUp(sender, message, true));
    }

    private List<Character> getResponsiveCharacters(String sender, class_2561 message) {
        String txt = message.getString();
        List<Character> allCharacters = this.characters.stream().filter(character -> !sender.contentEquals(character.name.getString())).toList();
        if (allCharacters.isEmpty()) {
            return allCharacters;
        }
        List<Character> mentionedCharacters = this.characters.stream().filter(character -> txt.contains(character.name.getString())).toList();
        if (mentionedCharacters.isEmpty()) {
            return List.of(allCharacters.get(this.player.method_59922().method_43048(allCharacters.size())));
        }
        return mentionedCharacters;
    }

    final class Character {
        private int idleTicks;
        private int sleepTicks;
        private final Queue<DelayedMessage> messageQueue = new LinkedList<DelayedMessage>();
        private final class_2561 name;
        private final class_2556.class_7602 parameters;

        Character() {
            this.name = ChatBot.this.personality.getName(ChatBot.this.player.method_59922());
            this.parameters = class_2556.method_44834((class_5321)class_2556.field_11737, (class_5455)ChatBot.this.player.method_37908().method_30349(), (class_2561)this.name);
        }

        public boolean tick() {
            DelayedMessage message;
            if (this.sleepTicks-- > 0) {
                return false;
            }
            if (this.messageQueue.isEmpty() && this.idleTicks++ > 300 && ChatBot.this.player.method_59922().method_43048(300) == 0) {
                if (ChatBot.this.player.method_59922().method_43048(120) == 0) {
                    return true;
                }
                ChatBot.this.personality.supplyMessage(ChatBot.this.player.method_59922(), line -> this.messageQueue.add(new DelayedMessage((class_2561)line)));
                this.sleepTicks = ChatBot.this.player.method_59922().method_39332(5, 100);
                this.idleTicks = 0;
            }
            if ((message = this.messageQueue.peek()) != null) {
                if (message.tick()) {
                    this.messageQueue.poll();
                }
                this.sleepTicks = ChatBot.this.player.method_59922().method_39332(2, 20);
            }
            return false;
        }

        public void wakeUp(String sender, class_2561 message, boolean fromPlayer) {
            this.messageQueue.clear();
            ChatBot.this.personality.onMessageReceived(sender, message, ChatBot.this.player.method_59922(), fromPlayer, line -> this.messageQueue.add(new DelayedMessage((class_2561)line)));
            this.idleTicks = 0;
            this.sleepTicks = ChatBot.this.player.method_59922().method_39332(1, 5);
        }

        class DelayedMessage {
            class_2561 message;
            int delay;

            public DelayedMessage(class_2561 message) {
                this.message = message;
                this.delay = ChatBot.this.player.method_59922().method_39332(2, 20);
            }

            public boolean tick() {
                if (--this.delay <= 0) {
                    ChatBot.this.emitMessage(Character.this.name.getString(), Character.this.parameters.method_44837(this.message));
                    return true;
                }
                return false;
            }
        }
    }
}

