/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.hallucination.HallucinationTypes;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class Visualisations {
    private final HallucinationTypes hallucinationTypes = new HallucinationTypes();
    private final IntList activeHallucinations = new IntArrayList();
    private final Int2FloatMap hallucinationStrengths = new Int2FloatOpenHashMap();

    public float getMultiplier(int hallucination) {
        return this.hallucinationTypes.getMultiplier(hallucination) * this.hallucinationStrengths.get(hallucination);
    }

    void update(DrugProperties properties) {
        float totalHallucinationValue = this.hallucinationTypes.update(properties);
        int desiredHallucinations = Math.max(0, class_3532.method_15375((float)(totalHallucinationValue * 8.0f + 0.9f)));
        class_5819 random = properties.asEntity().method_59922();
        while (this.activeHallucinations.size() > 0 && random.method_43057() < 1.0f / (float)(6000 / this.activeHallucinations.size())) {
            this.removeRandomHallucination(random);
        }
        while (this.activeHallucinations.size() > desiredHallucinations) {
            this.removeRandomHallucination(random);
        }
        while (this.activeHallucinations.size() < desiredHallucinations && this.addRandomHallucination(random)) {
        }
        IntListIterator intListIterator = HallucinationTypes.ALL.iterator();
        while (intListIterator.hasNext()) {
            int hKey = (Integer)intListIterator.next();
            this.hallucinationStrengths.compute(hKey, (key, val) -> Float.valueOf(MathUtils.nearValue(val == null ? 0.0f : val.floatValue(), this.activeHallucinations.contains(key.intValue()) ? MathUtils.randomColor(random, properties.getAge(), this.hallucinationTypes.getMultiplier((int)key), 0.5f, 0.00121f, 0.0019318f) : 0.0f, 0.002f, 0.002f)));
        }
    }

    private void removeRandomHallucination(class_5819 random) {
        this.activeHallucinations.removeInt(random.method_43048(this.activeHallucinations.size()));
    }

    private boolean addRandomHallucination(class_5819 random) {
        float maxValue = 0.0f;
        int currentHallucination = -1;
        IntListIterator intListIterator = HallucinationTypes.ALL.iterator();
        while (intListIterator.hasNext()) {
            float value;
            int hKey = (Integer)intListIterator.next();
            if (this.activeHallucinations.contains(hKey) || !((value = random.method_43057() * this.hallucinationTypes.getMultiplier(hKey)) > maxValue)) continue;
            currentHallucination = hKey;
            maxValue = value;
        }
        if (currentHallucination >= 0) {
            this.activeHallucinations.add(currentHallucination);
            return true;
        }
        return false;
    }
}

