/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.sound;

import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.util.MathUtils;
import ivorius.psychedelicraft.util.NbtSerialisable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class DrugMusicManager
implements NbtSerialisable {
    public static final float PLAY_THRESHOLD = 0.01f;
    final DrugProperties properties;
    private int delayUntilHeartbeat;
    private int delayUntilBreath;
    private boolean lastBreathWasIn;
    private float prevHeartbeatPulseStrength;
    private float heartbeatPulseStrength;
    private float targetHeartbeatPulseStrength;

    public DrugMusicManager(DrugProperties properties) {
        this.properties = properties;
    }

    public void copyFrom(DrugMusicManager old, boolean alive) {
        if (alive) {
            this.delayUntilHeartbeat = old.delayUntilHeartbeat;
            this.delayUntilBreath = old.delayUntilBreath;
            this.lastBreathWasIn = old.lastBreathWasIn;
            this.prevHeartbeatPulseStrength = old.prevHeartbeatPulseStrength;
            this.heartbeatPulseStrength = old.heartbeatPulseStrength;
            this.targetHeartbeatPulseStrength = old.targetHeartbeatPulseStrength;
        }
    }

    public void update() {
        float speed;
        class_1657 entity = this.properties.asEntity();
        if (this.delayUntilHeartbeat > 0) {
            --this.delayUntilHeartbeat;
        }
        this.prevHeartbeatPulseStrength = this.heartbeatPulseStrength;
        this.heartbeatPulseStrength = Math.max(0.0f, MathUtils.approach(this.heartbeatPulseStrength, this.targetHeartbeatPulseStrength, 0.2f));
        if (this.targetHeartbeatPulseStrength > 0.0f) {
            this.targetHeartbeatPulseStrength = Math.max(0.0f, this.targetHeartbeatPulseStrength - 0.02f);
        }
        if (this.delayUntilHeartbeat == 0) {
            float heartbeatVolume = this.properties.getModifier(Drug.HEART_BEAT_VOLUME);
            speed = this.properties.getModifier(Drug.HEART_BEAT_SPEED);
            if (heartbeatVolume > 0.0f) {
                this.delayUntilHeartbeat = speed <= 1.0f ? -class_3532.method_15386((float)(350.0f * (speed == 1.0f ? -1.0f : speed - 1.0f))) : class_3532.method_15375((float)(35.0f / (speed - 1.0f)));
                this.targetHeartbeatPulseStrength = Math.max(0.0f, 2.0f - this.properties.getModifier(Drug.PAIN_SUPPRESSION));
                entity.method_37908().method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), PSSounds.ENTITY_PLAYER_HEARTBEAT, class_3419.field_15256, heartbeatVolume, speed, false);
            }
        }
        if (this.delayUntilBreath > 0) {
            --this.delayUntilBreath;
        }
        if (this.delayUntilBreath == 0) {
            this.lastBreathWasIn = !this.lastBreathWasIn;
            float breathVolume = this.properties.getModifier(Drug.BREATH_VOLUME);
            if (breathVolume > 0.0f) {
                speed = this.properties.getModifier(Drug.BREATH_SPEED);
                this.delayUntilBreath = class_3532.method_15375((float)(30.0f / speed));
                entity.method_37908().method_43129((class_1297)entity, (class_1297)entity, PSSounds.ENTITY_PLAYER_BREATH, class_3419.field_15248, breathVolume, speed * 0.05f + 0.9f + (this.lastBreathWasIn ? 0.15f : 0.0f));
            }
        }
    }

    public float getHeartbeatPulseStrength(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevHeartbeatPulseStrength, (float)this.heartbeatPulseStrength);
    }

    @Override
    public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10569("delayUntilHeartbeat", this.delayUntilHeartbeat);
        compound.method_10569("delayUntilBreath", this.delayUntilBreath);
        compound.method_10556("lastBreathWasIn", this.lastBreathWasIn);
        compound.method_10548("heartbeatPulseStrength", this.heartbeatPulseStrength);
        compound.method_10548("targetHeartbeatPulseStrength", this.targetHeartbeatPulseStrength);
    }

    @Override
    public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.delayUntilHeartbeat = compound.method_68083("delayUntilHeartbeat", 0);
        this.delayUntilBreath = compound.method_68083("delayUntilBreath", 0);
        this.lastBreathWasIn = compound.method_68566("lastBreathWasIn", false);
        this.heartbeatPulseStrength = compound.method_66563("heartbeatPulseStrength", 0.0f);
        this.targetHeartbeatPulseStrength = compound.method_66563("targetHeartbeatPulseStrength", 0.0f);
    }
}

