/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.type;

import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.entity.drug.DrugAttributeFunctions;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class AlcoholDrug
extends SimpleDrug {
    public static final DrugAttributeFunctions FUNCTIONS = DrugAttributeFunctions.builder().put(VIEW_WOBBLYNESS, 0.5f).put(DOUBLE_VISION, f -> MathUtils.project(f, 0.25f, 1.0f)).put(MOTION_BLUR, f -> MathUtils.project(f, 0.5f, 1.0f) * 0.3f).build();

    public AlcoholDrug(DrugType<AlcoholDrug> type, double decSpeed, double decSpeedPlus) {
        super(type, decSpeed, decSpeedPlus);
    }

    @Override
    protected boolean tickSideEffects(class_3218 world, DrugProperties properties, class_5819 random) {
        class_1657 entity = properties.asEntity();
        double activeValue = this.getActiveValue();
        if (this.getTicksActive() % 20 == 0 && (double)random.method_43057() < (activeValue - (double)0.9f) * 2.0) {
            PSDamageTypes.damage(world, (class_1297)entity, world.method_48963().method_48795(PSDamageTypes.ALCOHOL_POSIONING), (int)((activeValue - (double)0.9f) * 50.0 + 4.0));
            if (entity.method_29504()) {
                return true;
            }
        }
        return super.tickSideEffects(world, properties, random);
    }

    @Override
    protected void tickClientEffects(DrugProperties properties, class_5819 random) {
        class_1657 entity = properties.asEntity();
        double activeValue = this.getActiveValue();
        double motionEffect = Math.min(activeValue, 0.8) + class_3532.method_15350((double)entity.method_18798().method_1033(), (double)0.0, (double)1.0) * 3.0 * activeValue;
        AlcoholDrug.rotateEntityPitch((class_1297)entity, (double)(class_3532.method_15374((float)((float)entity.field_6012 / 600.0f * (float)Math.PI)) / 2.0f) * motionEffect * (double)(random.method_43057() + 0.5f));
        AlcoholDrug.rotateEntityYaw((class_1297)entity, (double)(class_3532.method_15362((float)((float)entity.field_6012 / 500.0f * (float)Math.PI)) / 1.3f) * motionEffect * (double)(random.method_43057() + 0.5f));
        AlcoholDrug.rotateEntityPitch((class_1297)entity, (double)(class_3532.method_15374((float)((float)entity.field_6012 / 180.0f * (float)Math.PI)) / 3.0f) * motionEffect * (double)(random.method_43057() + 0.5f));
        AlcoholDrug.rotateEntityYaw((class_1297)entity, (double)(class_3532.method_15362((float)((float)entity.field_6012 / 150.0f * (float)Math.PI)) / 2.0f) * motionEffect * (double)(random.method_43057() + 0.5f));
    }

    @Override
    public void onWakeUp(class_3218 world, DrugProperties drugProperties) {
        double value = this.getActiveValue();
        super.onWakeUp(world, drugProperties);
        if (value > 0.0) {
            class_1657 player = drugProperties.asEntity();
            class_5819 random = player.method_37908().field_9229;
            if ((double)random.method_43057() > 1.0 - value) {
                player.method_5879(random.method_43057() * ((float)Math.PI * 2));
                player.method_5783(class_3417.field_15115, 1.0f, 1.0f);
                drugProperties.addToDrug(DrugType.SLEEP_DEPRIVATION, 0.25);
                PSCriteria.HANGOVER.trigger(player);
            }
        }
    }
}

