/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.DrugFluid;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.fluid.physical.FluidStateManager;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

public class CoffeeFluid
extends DrugFluid
implements Processable {
    public static final SimpleFluid.Attribute<Integer> WARMTH = SimpleFluid.Attribute.ofInt("warmth", 0, 2);
    private static final FluidStateManager.FluidProperty<Integer> TEMPERATURE = new FluidStateManager.FluidProperty<Integer>((class_2769<Integer>)class_2758.method_11867((String)"temperature", (int)0, (int)2), (BiConsumer<Map<String, Integer>, Integer>)((BiConsumer<Map, Integer>)WARMTH::set), WARMTH::get);

    public CoffeeFluid(class_2960 id, DrugFluid.Settings settings) {
        super(id, (DrugFluid.Settings)settings.with(TEMPERATURE));
    }

    @Override
    protected void getDrugInfluencesPerLiter(ItemFluids stack, Consumer<DrugInfluence> consumer) {
        super.getDrugInfluencesPerLiter(stack, consumer);
        float warmth = (float)WARMTH.get(stack).intValue() / 2.0f;
        consumer.accept(new DrugInfluence(DrugType.CAFFEINE, 20, 0.002, 0.001, 0.25f + warmth * 0.05f));
        consumer.accept(new DrugInfluence(DrugType.WARMTH, 0, 0.1, 0.0, 0.8f * warmth));
    }

    @Override
    public void onRandomTick(class_3218 world, class_2338 pos, class_3610 state, class_5819 random) {
        int temperature = (Integer)state.method_11654(TEMPERATURE.property());
        if (temperature > 0 && world.method_8320(pos).method_26204() instanceof class_2404) {
            world.method_8501(pos, ((class_3610)state.method_11657(TEMPERATURE.property(), (Comparable)Integer.valueOf(temperature - 1))).method_15759());
        }
    }

    @Override
    public class_2561 getName(ItemFluids stack) {
        return class_2561.method_43471((String)(this.getTranslationKey() + ".temperature." + String.valueOf(WARMTH.get(stack))));
    }

    @Override
    public Stream<ItemFluids> getDefaultStacks(int capacity) {
        return Stream.concat(super.getDefaultStacks(capacity), WARMTH.steps().map(class_3545::method_15441).map(warmth -> WARMTH.set(this.getDefaultStack(capacity), (Integer)warmth)));
    }

    @Override
    public String getUniqueKey(ItemFluids fluids) {
        return switch (WARMTH.get(fluids)) {
            case 1 -> "_warm";
            case 2 -> "_hot";
            default -> "_cold";
        };
    }

    @Override
    public boolean isSuitableContainer(class_1799 container) {
        return container.method_31573(this.getPreferredContainerTag());
    }

    @Override
    public class_6862<class_1792> getPreferredContainerTag() {
        return PSTags.Items.SUITABLE_HOT_DRINK_RECEPTICALS;
    }

    @Override
    public Processable.ProcessType modifyProcess(Resovoir tank, Processable.ProcessType type) {
        return WARMTH.get(tank.getContents()) > 0 ? Processable.ProcessType.COOL : type;
    }

    @Override
    public int getProcessingTime(Resovoir tank, Processable.ProcessType type) {
        return switch (type) {
            case Processable.ProcessType.COOL -> {
                if (WARMTH.get(tank.getContents()) > 0) {
                    yield 300;
                }
                yield -1;
            }
            case Processable.ProcessType.PURIFY -> 1;
            default -> -1;
        };
    }

    @Override
    public void process(Processable.Context context, Processable.ProcessType type, Processable.ByProductConsumer output) {
        Resovoir tank = context.getPrimaryTank();
        if (type == Processable.ProcessType.COOL) {
            tank.setContents(WARMTH.set(tank.getContents(), (Integer)Math.max(0, WARMTH.get(tank.getContents()) - 1)));
        }
        if (type == Processable.ProcessType.PURIFY) {
            int amount = Math.max(1, context.getPrimaryTank().getContents().amount() / 10);
            context.getPrimaryTank().drain(amount * 2);
            output.accept(PSFluids.CAFFEINE.getDefaultStack(amount));
        }
    }

    @Override
    public Stream<Processable.Process> getProcesses() {
        return Stream.concat(WARMTH.steps().flatMapToInt(step -> IntStream.of((Integer)step.method_15442(), (Integer)step.method_15441())).distinct().mapToObj(warmth -> new Processable.Process(this, this.getId().method_48331("_purifying_" + warmth), List.of(new Processable.Transition(Processable.ProcessType.PURIFY, 0, 1, from -> WARMTH.set((ItemFluids)from, (Integer)warmth).ofAmount(2), to -> PSFluids.CAFFEINE.getDefaultStack(1))))), Stream.of(new Processable.Process(this, this.getId().method_48331("_cooling"), WARMTH.steps().map(step -> new Processable.Transition(Processable.ProcessType.FERMENT, 300, -1, stack -> WARMTH.set((ItemFluids)stack, (Integer)step.method_15441()), stack -> WARMTH.set((ItemFluids)stack, (Integer)step.method_15442()))).toList())));
    }

    @Override
    public int getHash(ItemFluids stack) {
        return Objects.hash(this, WARMTH.get(stack));
    }
}

