/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.entity.FluidProcessingBlockEntity;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.particle.DrugDustParticleEffect;
import ivorius.psychedelicraft.particle.PSParticles;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_5945;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Nullable;

public class SlurryFluid
extends SimpleFluid
implements Processable {
    public static final int FLUID_PER_DIRT = 324000;

    public SlurryFluid(class_2960 id, SimpleFluid.Settings settings) {
        super(id, (SimpleFluid.Settings)settings.sprites(id.method_45134(p -> "block/fluid/" + p + "_flow"), id.method_45134(p -> "block/fluid/" + p + "_still")));
    }

    @Override
    public void randomDisplayTick(class_1937 world, class_2338 pos, class_3610 state, class_5819 random) {
        class_5945.method_34682((class_1937)world, (class_2338)pos, (class_2394)new DrugDustParticleEffect(PSParticles.BUBBLE, this.getColor(this.getDefaultStack()), 1.0f), (class_6017)class_6016.method_34998((int)5));
        world.method_45446(pos, class_3417.field_15065, class_3419.field_15245, 0.5f + world.method_8409().method_43057(), 0.3f + world.method_8409().method_43057(), true);
    }

    @Override
    public Processable.ProcessType modifyProcess(Resovoir tank, Processable.ProcessType type) {
        return type == Processable.ProcessType.FERMENT || type == Processable.ProcessType.MATURE ? Processable.ProcessType.SEPARATE : type;
    }

    @Override
    public int getProcessingTime(Resovoir tank, Processable.ProcessType type) {
        if (type == Processable.ProcessType.SEPARATE) {
            return tank.getContents().amount() >= 324000 ? (Integer)Psychedelicraft.getConfig().slurryHardeningTime.get() : -1;
        }
        return -1;
    }

    @Override
    public void process(Processable.Context context, Processable.ProcessType type, Processable.ByProductConsumer output) {
        Resovoir tank;
        if (type == Processable.ProcessType.SEPARATE && (tank = context.getPrimaryTank()).getContents().amount() >= 324000) {
            tank.drain(324000);
            output.accept(class_1802.field_37537.method_7854());
            output.accept(SimpleFluid.of((class_3611)class_3612.field_15910).getDefaultStack(243000));
        }
    }

    @Override
    public Stream<Processable.Process> getProcesses() {
        return Stream.empty();
    }

    @Override
    public void appendTankTooltip(ItemFluids stack, @Nullable class_1937 world, List<class_2561> tooltip, FluidProcessingBlockEntity tank) {
        super.appendTankTooltip(stack, world, tooltip, tank);
        if (tank.getProcessType() == Processable.ProcessType.DISTILL || tank.getProcessType() == Processable.ProcessType.FERMENT) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Requirements:"));
            if (tank.getPrimaryTank().getAmount() < 324000L) {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Requires 4 buckets of slurry to process").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Has 4 buckets of slurry").method_27692(class_124.field_1080));
            }
        }
    }
}

