/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.alcohol;

import com.google.common.base.Preconditions;
import ivorius.psychedelicraft.fluid.alcohol.AlcoholicFluidState;
import ivorius.psychedelicraft.fluid.alcohol.DrinkType;
import ivorius.psychedelicraft.fluid.alcohol.FluidAppearance;
import ivorius.psychedelicraft.fluid.alcohol.StatePredicate;
import ivorius.psychedelicraft.item.component.ItemFluids;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_3532;

public interface DrinkTypes {
    public static final DrinkTypes EMPTY = new Builder(List.of(), Set.of());

    public static DrinkTypes empty() {
        return EMPTY;
    }

    public List<Variant> variants();

    default public DrinkType find(ItemFluids fluids) {
        if (!this.variants().isEmpty()) {
            for (Variant variant : this.variants()) {
                if (!variant.predicate.test(fluids)) continue;
                return variant.value();
            }
        }
        return this.variants().get(0).value();
    }

    default public int findId(ItemFluids fluids) {
        for (int i = 0; i < this.variants().size(); ++i) {
            if (!this.variants().get(i).predicate().test(fluids)) continue;
            return i;
        }
        return 0;
    }

    default public AlcoholicFluidState findState(int id) {
        return this.variants().get(class_3532.method_15340((int)id, (int)0, (int)this.variants().size())).predicate().state();
    }

    public static Builder builder(DrinkType baseForm) {
        return new Builder(new ArrayList<Variant>(), new HashSet<AlcoholicFluidState>()).add(baseForm, StatePredicate.BASE);
    }

    public static Builder builder(String wort) {
        return DrinkTypes.builder(DrinkType.WORT.withVariation(wort));
    }

    public static Builder builder(FluidAppearance wort) {
        return DrinkTypes.builder(DrinkType.WORT.withAppearance(wort));
    }

    public record Variant(DrinkType value, StatePredicate predicate) {
    }

    public record Builder(List<Variant> variants, Set<AlcoholicFluidState> states) implements DrinkTypes
    {
        public Builder add(DrinkType variant, StatePredicate.Builder builder) {
            return this.add(variant, builder.build());
        }

        public Builder add(DrinkType variant, StatePredicate predicate) {
            this.variants.add(new Variant(variant, predicate));
            Preconditions.checkArgument((boolean)this.states.add(predicate.state()), (Object)("Drink type overlap for " + String.valueOf(variant) + " and " + String.valueOf(predicate)));
            return this;
        }

        public Builder vinegar(DrinkType type) {
            return this.add(type, StatePredicate.VINEGAR);
        }

        public Builder firstFerment(DrinkType type) {
            return this.add(type, StatePredicate.FERMENTED_1);
        }

        public Builder secondFerment(DrinkType type) {
            return this.add(type, StatePredicate.FERMENTED_2);
        }

        public Builder distilled(DrinkType type) {
            return this.add(type, StatePredicate.FERMENTED_DISTILLED);
        }

        public Builder matured(DrinkType type) {
            return this.add(type, StatePredicate.FERMENTED_MATURED);
        }

        public Builder matureDistilled(DrinkType type) {
            return this.add(type, StatePredicate.FERMENTED_MATURED_DISTILLED);
        }
    }

    public record Entry(AlcoholicFluidState state, Variant variant) {
    }
}

