/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.container;

import com.mojang.datafixers.util.Pair;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.DrinkableItem;
import ivorius.psychedelicraft.item.FilledBucketItem;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_156;
import net.minecraft.class_1754;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class RecepticalHandler {
    private static final List<Pair<Predicate<class_1799>, RecepticalHandler>> REGISTRY = new ArrayList<Pair<Predicate<class_1799>, RecepticalHandler>>();
    private static final RecepticalHandler DEFAULT = new RecepticalHandler();

    public static RecepticalHandler get(class_1799 stack) {
        return REGISTRY.stream().filter(pair -> ((Predicate)pair.getFirst()).test(stack)).map(Pair::getSecond).findFirst().orElse(DEFAULT);
    }

    public static void register(class_1792 item, RecepticalHandler handler) {
        RecepticalHandler.register((class_1799 i) -> i.method_31574(item), handler);
    }

    public static void register(class_6862<class_1792> tag, RecepticalHandler handler) {
        RecepticalHandler.register((class_1799 i) -> i.method_31573(tag), handler);
    }

    public static void register(Predicate<class_1799> item, RecepticalHandler handler) {
        REGISTRY.add((Pair<Predicate<class_1799>, RecepticalHandler>)new Pair(item, (Object)handler));
    }

    public static void registerPair(class_1792 empty, class_1792 filled, RecepticalHandler handler) {
        RecepticalHandler.register((class_1799 i) -> i.method_31574(empty) || i.method_31574(filled), handler);
    }

    public static void registerPair(final class_1792 empty, final class_1792 filled) {
        RecepticalHandler.registerPair(empty, filled, new RecepticalHandler(){

            @Override
            public class_1799 toFilled(class_1799 item, ItemFluids contents) {
                return 1.applyFluid(1.changeStackType(item, filled), contents);
            }

            @Override
            public class_1799 toEmpty(class_1799 item) {
                return 1.applyFluid(1.changeStackType(item, empty), ItemFluids.EMPTY);
            }
        });
    }

    public static class_1799 changeStackType(class_1799 item, class_1792 newType) {
        return item.method_7909() == newType ? item : item.method_60503((class_1935)newType);
    }

    public static class_1799 applyFluid(class_1799 stack, ItemFluids contents) {
        if (contents.isEmpty()) {
            if (stack.method_57826(PSComponents.FLUIDS)) {
                stack.method_57381(PSComponents.FLUIDS);
            }
        } else {
            stack.method_57379(PSComponents.FLUIDS, (Object)contents);
        }
        return stack;
    }

    public class_1799 toFilled(class_1799 item, ItemFluids contents) {
        return RecepticalHandler.applyFluid(item.method_7972(), contents);
    }

    public class_1799 toEmpty(class_1799 item) {
        return RecepticalHandler.applyFluid(item.method_7972(), ItemFluids.EMPTY);
    }

    static {
        RecepticalHandler.register((class_1799 stack) -> stack.method_31573(ConventionalItemTags.BUCKETS) || stack.method_31573(ConventionalItemTags.EMPTY_BUCKETS) || stack.method_31574((class_1792)PSItems.FILLED_BUCKET), new RecepticalHandler(){
            private final Function<SimpleFluid, Optional<class_1792>> filledBuckets = class_156.method_34866(fluid -> {
                String path = fluid.getId().method_12832() + "_bucket";
                return class_7923.field_41178.method_10235().stream().filter(id -> id.method_12832().equals(path)).findFirst().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0));
            });

            @Override
            public class_1799 toFilled(class_1799 item, ItemFluids contents) {
                FilledBucketItem newType = contents.amount() < 81000 || !contents.isBaseForm() ? PSItems.FILLED_BUCKET : this.filledBuckets.apply(contents.fluid()).orElse((class_1792)PSItems.FILLED_BUCKET);
                return 2.applyFluid(2.changeStackType(item, (class_1792)newType), newType == PSItems.FILLED_BUCKET ? contents : ItemFluids.EMPTY);
            }

            @Override
            public class_1799 toEmpty(class_1799 item) {
                return 2.applyFluid(2.changeStackType(item, class_1802.field_8550), ItemFluids.EMPTY);
            }
        });
        RecepticalHandler.registerPair(class_1802.field_8428, PSItems.FILLED_BOWL);
        RecepticalHandler.register((class_1799 stack) -> stack.method_7909() instanceof class_1754 || stack.method_7909() instanceof class_1812 || stack.method_7909() == PSItems.FILLED_GLASS_BOTTLE, new RecepticalHandler(){
            private final Function<SimpleFluid, Optional<class_1792>> filledBottles = class_156.method_34866(fluid -> {
                String path = fluid.getId().method_12832() + "_bottle";
                String altPath = fluid.getId().method_12832() + "_glass_bottle";
                return class_7923.field_41178.method_10235().stream().filter(id -> id.method_12832().equals(path) || id.method_12832().equals(altPath)).findFirst().map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0));
            });

            @Override
            public class_1799 toFilled(class_1799 item, ItemFluids contents) {
                if (contents.amount() < 27000) {
                    return 3.applyFluid(3.changeStackType(item, PSItems.FILLED_GLASS_BOTTLE), contents);
                }
                if (contents.isOf((class_3611)class_3612.field_15910)) {
                    return class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991);
                }
                DrinkableItem newType = contents.amount() < 27000 || !contents.isBaseForm() ? PSItems.FILLED_GLASS_BOTTLE : this.filledBottles.apply(contents.fluid()).orElse(PSItems.FILLED_GLASS_BOTTLE);
                return 3.applyFluid(3.changeStackType(item, newType), newType == PSItems.FILLED_GLASS_BOTTLE ? contents : ItemFluids.EMPTY);
            }

            @Override
            public class_1799 toEmpty(class_1799 item) {
                return 3.applyFluid(3.changeStackType(item, class_1802.field_8469), ItemFluids.EMPTY);
            }
        });
    }
}

