/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid.container;

import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.container.FluidTransferUtils;
import ivorius.psychedelicraft.item.FilledBucketItem;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.FullItemFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3545;
import net.minecraft.class_3611;

public final class VariantMarshal {
    public static void bootstrap() {
        FluidStorage.GENERAL_COMBINED_PROVIDER.register(context -> {
            class_1799 stack = context.getItemVariant().toStack();
            if (stack.method_58694(PSComponents.FLUIDS) != null) {
                return new ItemFluidsStorage(context);
            }
            if (stack.method_31574(class_1802.field_8103)) {
                return new FullItemFluidStorage(context, class_1802.field_8550, FluidVariant.of((class_3611)PSFluids.MILK.getPhysical().getStandingFluid()), 81000L);
            }
            return null;
        });
        FilledBucketItem.registerDispenserBehaviour(class_1802.field_8103);
    }

    public static final class ItemFluidsStorage
    implements FabricResovoir {
        private final ContainerItemContext context;

        public ItemFluidsStorage(ContainerItemContext context) {
            this.context = context;
        }

        @Override
        public ItemFluids getContents() {
            return ItemFluids.direct(this.getCurrentStack());
        }

        private class_1799 getCurrentStack() {
            return this.context.getItemVariant().toStack();
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            ItemFluids inputFluids = ItemFluids.of(resource, (int)maxAmount);
            ItemFluids.DirectTransaction t = new ItemFluids.DirectTransaction(this.getCurrentStack(), (int)this.getCapacity(), ItemFluids.direct(this.getCurrentStack()));
            inputFluids = t.deposit(inputFluids);
            long difference = maxAmount - (long)inputFluids.amount();
            if (difference == 0L) {
                return 0L;
            }
            this.context.exchange(ItemVariant.of((class_1799)t.toItemStack()), 1L, transaction);
            return difference;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            ItemFluids fluids = ItemFluids.direct(this.getCurrentStack());
            if (!fluids.canCombine(ItemFluids.of(resource, (int)maxAmount))) {
                return 0L;
            }
            ItemFluids.DirectTransaction t = new ItemFluids.DirectTransaction(this.getCurrentStack(), (int)this.getCapacity(), fluids);
            ItemFluids withdrawn = t.withdraw((int)maxAmount);
            if (withdrawn.isEmpty()) {
                return 0L;
            }
            this.context.exchange(ItemVariant.of((class_1799)t.toItemStack()), 1L, transaction);
            return withdrawn.amount();
        }

        public long getCapacity() {
            FluidCapacity capacity = (FluidCapacity)this.getCurrentStack().method_58694(PSComponents.FLUID_CAPACITY);
            return capacity == null ? 0L : (long)capacity.capacity();
        }
    }

    static interface FabricResovoir
    extends SingleSlotStorage<FluidVariant> {
        public ItemFluids getContents();

        default public boolean isResourceBlank() {
            return this.getContents().isEmpty();
        }

        default public FluidVariant getResource() {
            return this.getContents().toVariant();
        }

        default public long getAmount() {
            return this.getContents().amount();
        }
    }

    public static final class FabricTransaction
    implements ItemFluids.Transaction {
        private class_1799 stack;
        private ItemFluids fluids;

        public FabricTransaction(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public int capacity() {
            return (int)FluidTransferUtils.getCapacity(this.stack);
        }

        @Override
        public ItemFluids fluids() {
            if (this.fluids == null) {
                this.fluids = FluidTransferUtils.getContents(this.stack).map(contents -> ItemFluids.of((FluidVariant)contents.method_15441(), ((Long)contents.method_15442()).intValue())).orElse(ItemFluids.EMPTY);
            }
            return this.fluids;
        }

        @Override
        public ItemFluids withdraw(int amount) {
            class_3545<class_1799, Optional<class_3545<Long, FluidVariant>>> result = FluidTransferUtils.extract(this.stack, amount);
            if (((Optional)result.method_15441()).isEmpty() && this.fluids.amount() > 0) {
                ItemFluids.DirectTransaction t = new ItemFluids.DirectTransaction(this.stack, this.capacity(), this.fluids);
                ItemFluids removed = t.withdraw(amount);
                this.stack = t.toItemStack();
                this.fluids = t.fluids();
                return removed;
            }
            this.stack = (class_1799)result.method_15442();
            this.fluids = null;
            return ((Optional)result.method_15441()).map(fluid -> ItemFluids.of((FluidVariant)fluid.method_15441(), ((Long)fluid.method_15442()).intValue())).orElse(ItemFluids.EMPTY);
        }

        @Override
        public ItemFluids deposit(ItemFluids fluids, int maxAmount) {
            maxAmount = Math.min(maxAmount, fluids.amount());
            class_3545<class_1799, Long> result = FluidTransferUtils.deposit(this.stack, fluids.toVariant(), maxAmount);
            if (this.fluids().amount() < this.capacity() && (Long)result.method_15441() == (long)maxAmount) {
                ItemFluids.DirectTransaction t = new ItemFluids.DirectTransaction(this.stack, this.capacity(), this.fluids);
                ItemFluids remainder = t.deposit(fluids, maxAmount);
                this.stack = t.toItemStack();
                fluids = t.fluids();
                return remainder;
            }
            this.stack = (class_1799)result.method_15442();
            this.fluids = null;
            return fluids.ofAmount(fluids.amount() - (maxAmount -= ((Long)result.method_15441()).intValue()));
        }

        @Override
        public class_1799 toItemStack() {
            return this.stack;
        }
    }
}

