/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.FluidVolumes;
import ivorius.psychedelicraft.fluid.container.FluidTransferUtils;
import ivorius.psychedelicraft.fluid.container.RecepticalHandler;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import net.minecraft.class_9365;

public record FluidCapacity(int capacity) {
    private static final Interner<FluidCapacity> INTERNER = Interners.newStrongInterner();
    public static final FluidCapacity EMPTY = FluidCapacity.create(0);
    public static final Codec<FluidCapacity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("capacity").forGetter(FluidCapacity::capacity)).apply((Applicative)instance, FluidCapacity::create));
    public static final class_9139<class_9129, FluidCapacity> PACKET_CODEC = class_9139.method_56434((class_9139)class_9135.field_49675, FluidCapacity::capacity, FluidCapacity::create);

    public static FluidCapacity create(int capacity) {
        return (FluidCapacity)INTERNER.intern((Object)new FluidCapacity(capacity));
    }

    public static int get(class_1799 stack) {
        FluidCapacity capacity = (FluidCapacity)stack.method_58694(PSComponents.FLUID_CAPACITY);
        if (capacity == null) {
            class_1799 filledStack;
            int maxLevel = (int)FluidTransferUtils.getCapacity(stack);
            if (maxLevel == 0 && (filledStack = RecepticalHandler.get(stack).toFilled(stack, ItemFluids.of(FluidVariant.of((class_3611)class_3612.field_15910), 1))) != stack && filledStack.method_7909() != stack.method_7909() && (capacity = (FluidCapacity)filledStack.method_58694(PSComponents.FLUID_CAPACITY)) != null) {
                return capacity.capacity();
            }
            return maxLevel;
        }
        return capacity == null ? 0 : capacity.capacity();
    }

    public static void appendTooltip(class_1799 stack, class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.container.levels", (Object[])new Object[]{FluidVolumes.format(ItemFluids.of(stack).amount()), FluidVolumes.format(FluidCapacity.get(stack))}).method_27692(class_124.field_1064));
    }

    public static float getPercentage(class_1799 stack) {
        int capacity = FluidCapacity.get(stack);
        return capacity == 0 ? 0.0f : (float)ItemFluids.of(stack).amount() / (float)capacity;
    }

    public record Predicate(class_2096.class_2100 capacity) implements class_9365<FluidCapacity>
    {
        public static final Codec<Predicate> CODEC = class_2096.class_2100.field_45763.xmap(Predicate::new, Predicate::capacity);

        public class_9331<FluidCapacity> method_58163() {
            return PSComponents.FLUID_CAPACITY;
        }

        public boolean test(FluidCapacity capacity) {
            return this.capacity.method_9054(capacity.capacity());
        }
    }
}

