/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.FluidTransferUtils;
import ivorius.psychedelicraft.fluid.container.RecepticalHandler;
import ivorius.psychedelicraft.fluid.container.VariantMarshal;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluidsMixture;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2096;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9365;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public record ItemFluids(SimpleFluid fluid, int amount, Map<String, Integer> attributes) implements class_9299
{
    public static final ItemFluids EMPTY = new ItemFluids(PSFluids.EMPTY, 0, Map.of());
    public static final Codec<Map<String, Integer>> ATTRIBUTES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT);
    public static final Codec<ItemFluids> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SimpleFluid.CODEC.fieldOf("fluid").forGetter(ItemFluids::fluid), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(ItemFluids::amount), (App)ATTRIBUTES_CODEC.optionalFieldOf("attributes", Map.of()).forGetter(ItemFluids::attributes)).apply((Applicative)instance, ItemFluids::create));
    public static final class_9139<class_9129, ItemFluids> PACKET_CODEC = class_9139.method_56436(SimpleFluid.PACKET_CODEC, ItemFluids::fluid, (class_9139)class_9135.field_49675, ItemFluids::amount, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, (class_9139)class_9135.field_49675), ItemFluids::attributes, ItemFluids::create);

    @NotNull
    public static ItemFluids direct(class_1799 stack) {
        return (ItemFluids)stack.method_58695(PSComponents.FLUIDS, (Object)EMPTY);
    }

    @NotNull
    public static ItemFluids of(class_1799 stack) {
        Optional<class_3545<Long, FluidVariant>> fabricContents;
        ItemFluids fluids = (ItemFluids)stack.method_58694(PSComponents.FLUIDS);
        if (fluids == null && (fabricContents = FluidTransferUtils.getContents(stack)).isPresent()) {
            return ItemFluids.of((FluidVariant)fabricContents.get().method_15441(), ((Long)fabricContents.get().method_15442()).intValue());
        }
        return fluids == null ? ItemFluidsMixture.of(stack).getFirstFluid() : fluids;
    }

    public static List<ItemFluids> allOf(class_1799 stack) {
        ItemFluidsMixture mixture = ItemFluidsMixture.of(stack);
        return mixture.isEmpty() ? List.of(ItemFluids.of(stack)) : mixture.fluids();
    }

    public static ItemFluids of(FluidVariant variant, int capacity) {
        ItemFluids fluids;
        Optional fluidsOptional = variant.getComponents().method_57845(PSComponents.FLUIDS);
        ItemFluids itemFluids = fluids = fluidsOptional == null ? null : (ItemFluids)fluidsOptional.orElse(null);
        if (fluids == null) {
            return ItemFluids.create(SimpleFluid.of(variant.getFluid()), capacity, Map.of());
        }
        return fluids.ofAmount(capacity);
    }

    public FluidVariant toVariant() {
        return FluidVariant.of((class_3611)this.fluid().getPhysical().getStandingFluid(), (class_9326)class_9326.method_57841().method_57854(PSComponents.FLUIDS, (Object)this).method_57852());
    }

    public static ItemFluids create(SimpleFluid fluid, int amount, Map<String, Integer> attributes) {
        if (fluid.isEmpty() || amount <= 0) {
            return EMPTY;
        }
        return new ItemFluids(fluid, amount, Map.copyOf(attributes));
    }

    public static class_1799 set(class_1799 stack, ItemFluids fluids) {
        int capacity = FluidCapacity.get(stack);
        if (capacity > 0) {
            if (capacity < fluids.amount()) {
                fluids = ItemFluids.create(fluids.fluid(), capacity, fluids.attributes());
            }
            return ItemFluids.getItemForFluids(stack, fluids);
        }
        return stack;
    }

    public static class_1799 getItemForFluids(class_1799 original, ItemFluids fluids) {
        return fluids.isEmpty() ? RecepticalHandler.get(original).toEmpty(original) : RecepticalHandler.get(original).toFilled(original, fluids);
    }

    public ItemFluids withAttribute(String attribute, int value) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(this.attributes());
        attributes.put(attribute, value);
        return ItemFluids.create(this.fluid, this.amount, attributes);
    }

    public ItemFluids withAttributes(Map<String, Integer> attributes) {
        return ItemFluids.create(this.fluid(), this.amount(), attributes);
    }

    public ItemFluids ofAmount(int amount) {
        if (amount == this.amount()) {
            return this;
        }
        if (amount == 0) {
            return EMPTY;
        }
        return ItemFluids.create(this.fluid(), amount, this.attributes());
    }

    public class_1799 ofFilling(class_1799 container) {
        return ItemFluids.set(container, this.ofAmount(FluidCapacity.get(container)));
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean canCombine(ItemFluids fluids) {
        return this.isEmpty() || fluids.isEmpty() || this.isRoughlyEqual(fluids);
    }

    public int getHash() {
        return this.fluid.getHash(this);
    }

    public boolean isRoughlyEqual(ItemFluids fluids) {
        return this.fluid() == fluids.fluid() && this.getHash() == fluids.getHash();
    }

    public boolean isBaseForm() {
        return this.isEmpty() || this.isRoughlyEqual(this.fluid().getDefaultStack(this.amount()));
    }

    public boolean isOf(SimpleFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean isOf(class_3611 fluid) {
        return this.isOf(SimpleFluid.of(fluid));
    }

    public boolean isIn(class_6862<class_3611> tag) {
        return this.fluid().getPhysical().isIn(tag);
    }

    public class_2561 getName() {
        return this.fluid().getName(this);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
        this.fluid().appendTooltip(this, tooltip, type);
        if (type.method_8035()) {
            tooltip.accept((class_2561)class_2561.method_43470((String)"Contents:").method_27692(class_124.field_1063));
            if (this.isEmpty()) {
                tooltip.accept((class_2561)class_2561.method_43470((String)" <empty>").method_27692(class_124.field_1063));
            } else {
                tooltip.accept((class_2561)class_2561.method_43470((String)(" " + this.fluid().getId().toString() + " x" + this.amount())).method_27692(class_124.field_1063));
                for (Map.Entry<String, Integer> attribute : this.attributes().entrySet()) {
                    tooltip.accept((class_2561)class_2561.method_43470((String)("  " + attribute.getKey() + "=" + String.valueOf(attribute.getValue()))).method_27692(class_124.field_1063));
                }
            }
        }
    }

    public class_2520 encode() {
        return (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow();
    }

    public static ItemFluids decode(class_2520 nbt) {
        return CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt).result().map(pair -> (ItemFluids)pair.getFirst()).orElse(EMPTY);
    }

    public static class DirectTransaction
    implements Transaction {
        private class_1799 stack;
        private final int capacity;
        private ItemFluids fluids;

        public DirectTransaction(class_1799 initialStack) {
            this(initialStack, FluidCapacity.get(initialStack), ItemFluids.direct(initialStack));
        }

        public DirectTransaction(class_1799 initialStack, int capacity, ItemFluids fluids) {
            this.stack = initialStack.method_7972();
            this.capacity = capacity;
            this.fluids = fluids;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public ItemFluids fluids() {
            return this.fluids;
        }

        @Override
        public ItemFluids withdraw(int amount) {
            if (this.capacity <= 0) {
                return EMPTY;
            }
            ItemFluids removed = this.fluids.ofAmount(Math.min(amount, this.fluids.amount()));
            this.fluids = this.fluids.ofAmount(this.fluids.amount() - removed.amount());
            return removed;
        }

        @Override
        public ItemFluids deposit(ItemFluids fluids, int maxAmount) {
            if (this.capacity <= 0 || !this.fluids.canCombine(fluids)) {
                return fluids;
            }
            int maxInserted = Math.min(Math.min(this.capacity - this.fluids.amount(), fluids.amount()), maxAmount);
            if (maxInserted > 0) {
                this.fluids = fluids.ofAmount(this.fluids.amount() + maxInserted);
                if (maxInserted >= fluids.amount()) {
                    return EMPTY;
                }
                return fluids.ofAmount(fluids.amount() - maxInserted);
            }
            return fluids;
        }

        @Override
        public class_1799 toItemStack() {
            return ItemFluids.set(this.stack, this.fluids);
        }
    }

    public static interface Transaction {
        public static Transaction begin(class_1799 initialStack) {
            if (initialStack.method_58694(PSComponents.FLUID_CAPACITY) == null) {
                class_1799 filledStack;
                if (FluidTransferUtils.getCapacity(initialStack) == 0L && (filledStack = RecepticalHandler.get(initialStack).toFilled(initialStack, ItemFluids.of(FluidVariant.of((class_3611)class_3612.field_15910), 1))) != initialStack && filledStack.method_7909() != initialStack.method_7909() && filledStack.method_58694(PSComponents.FLUID_CAPACITY) != null) {
                    return new DirectTransaction(initialStack);
                }
                return new VariantMarshal.FabricTransaction(initialStack);
            }
            return new DirectTransaction(initialStack);
        }

        public int capacity();

        public ItemFluids withdraw(int var1);

        default public ItemFluids deposit(ItemFluids fluids) {
            return this.deposit(fluids, fluids.amount());
        }

        public ItemFluids deposit(ItemFluids var1, int var2);

        public ItemFluids fluids();

        public class_1799 toItemStack();

        default public boolean canAccept(ItemFluids fluids) {
            return this.canAccept(fluids, fluids.amount());
        }

        default public boolean canAccept(ItemFluids fluids, int amount) {
            return this.fluids().canCombine(fluids) && Math.min(fluids.amount(), this.capacity() - this.fluids().amount()) >= amount;
        }
    }

    public record Predicate(Optional<List<SimpleFluid>> fluid, class_2096.class_2100 amount, Map<String, class_2096.class_2100> attributes) implements class_9365<ItemFluids>
    {
        public static final Codec<Predicate> CODEC = RecordCodecBuilder.create(i -> i.group((App)SimpleFluid.CODEC.listOf().optionalFieldOf("fluid").forGetter(Predicate::fluid), (App)class_2096.class_2100.field_45763.optionalFieldOf("amount", (Object)class_2096.class_2100.field_9708).forGetter(Predicate::amount), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2096.class_2100.field_45763).optionalFieldOf("attributes", Map.of()).forGetter(Predicate::attributes)).apply((Applicative)i, Predicate::new));
        public static final class_9139<class_9129, Predicate> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56382((class_9139)SimpleFluid.PACKET_CODEC.method_56433(class_9135.method_56363())), Predicate::fluid, PacketCodecUtils.INT_RANGE, Predicate::amount, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, PacketCodecUtils.INT_RANGE), Predicate::attributes, Predicate::new);

        public class_9331<ItemFluids> method_58163() {
            return PSComponents.FLUIDS;
        }

        public boolean test(ItemFluids fluids) {
            return !(!this.fluid.isEmpty() && !this.fluid.get().contains(fluids.fluid()) || !this.amount.method_9054(fluids.amount()) || !this.attributes.isEmpty() && !this.attributes.entrySet().stream().allMatch(entry -> fluids.attributes().containsKey(entry.getKey()) && ((class_2096.class_2100)entry.getValue()).method_9054(fluids.attributes().get(entry.getKey()).intValue())));
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Optional<List<SimpleFluid>> fluid = Optional.empty();
            private class_2096.class_2100 amount = class_2096.class_2100.method_9053((int)1);
            private final Map<String, class_2096.class_2100> attributes = new HashMap<String, class_2096.class_2100>();

            public Builder fluid(SimpleFluid fluid) {
                this.fluid = Optional.of(List.of(fluid));
                return this;
            }

            public Builder fluid(SimpleFluid ... fluid) {
                this.fluid = Optional.of(List.of(fluid));
                return this;
            }

            public Builder fluid(Collection<SimpleFluid> fluid) {
                this.fluid = Optional.of(List.copyOf(fluid));
                return this;
            }

            public Builder amount(class_2096.class_2100 amount) {
                this.amount = amount;
                return this;
            }

            public Builder attribute(String name, class_2096.class_2100 range) {
                this.attributes.put(name, range);
                return this;
            }

            public Predicate build() {
                return new Predicate(this.fluid, this.amount, this.attributes);
            }
        }
    }
}

