/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.recipe.FluidMound;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public record ItemFluidsMixture(List<ItemFluids> fluids) implements class_9299
{
    private static final ItemFluidsMixture EMPTY = new ItemFluidsMixture(List.of());
    public static final Codec<ItemFluidsMixture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemFluids.CODEC.listOf().fieldOf("fluids").forGetter(ItemFluidsMixture::fluids)).apply((Applicative)instance, ItemFluidsMixture::of));
    public static final class_9139<class_9129, ItemFluidsMixture> PACKET_CODEC = class_9139.method_56434((class_9139)ItemFluids.PACKET_CODEC.method_56433(class_9135.method_56363()), ItemFluidsMixture::fluids, ItemFluidsMixture::of);

    public static ItemFluidsMixture of(List<ItemFluids> fluids) {
        return (fluids = ItemFluidsMixture.removeEmpty(fluids)).isEmpty() ? EMPTY : new ItemFluidsMixture(fluids);
    }

    @NotNull
    public static ItemFluidsMixture of(class_1799 stack) {
        ItemFluidsMixture fluids = (ItemFluidsMixture)stack.method_58694(PSComponents.FLUIDS_MIXTURE);
        return fluids == null ? EMPTY : fluids;
    }

    public static class_1799 set(class_1799 stack, List<ItemFluids> fluids) {
        int capacity = FluidCapacity.get(stack);
        if (capacity > 0) {
            ItemFluidsMixture mixture = ItemFluidsMixture.of(fluids);
            if (mixture.fluids.size() < 2) {
                stack.method_57381(PSComponents.FLUIDS_MIXTURE);
                return ItemFluids.set(stack, mixture.getFirstFluid());
            }
            stack = ItemFluids.getItemForFluids(stack, mixture.getFirstFluid());
            stack.method_57379(PSComponents.FLUIDS_MIXTURE, (Object)mixture);
        }
        return stack;
    }

    private static List<ItemFluids> removeEmpty(List<ItemFluids> fluids) {
        return FluidMound.of(fluids).getFluids();
    }

    public boolean isEmpty() {
        return this.fluids.isEmpty();
    }

    public ItemFluids getFirstFluid() {
        return this.isEmpty() ? ItemFluids.EMPTY : this.fluids.get(0);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
        if (this.isEmpty()) {
            return;
        }
        int total = this.fluids().stream().mapToInt(ItemFluids::amount).sum();
        tooltip.accept((class_2561)class_2561.method_43471((String)"psychedelicraft.container.mixture").method_27692(class_124.field_1063));
        this.fluids().forEach(fluid -> tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.container.mixture.fluid", (Object[])new Object[]{ItemFluidsMixture.getPercentage(fluid.amount(), total), fluid.getName()})));
    }

    static int getPercentage(int amount, int total) {
        return class_3532.method_15375((float)(100.0f * ((float)amount / (float)total)));
    }
}

