/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft;

import com.google.common.base.Suppliers;
import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.PSGameRules;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.command.PSCommands;
import ivorius.psychedelicraft.config.PSConfig;
import ivorius.psychedelicraft.entity.PSEntities;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.effect.PSEffects;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.container.VariantMarshal;
import ivorius.psychedelicraft.item.PSItemGroups;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.network.Channel;
import ivorius.psychedelicraft.particle.PSParticles;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.screen.PSScreenHandlers;
import ivorius.psychedelicraft.world.gen.PSWorldGen;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Psychedelicraft
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_NAMESPACE = "psychedelicraft";
    public static final String VANILLA_EXTENSIONS_NAMESPACE = "psychedelicraftmc";
    public static Supplier<Optional<DrugProperties>> globalDrugProperties = Optional::empty;
    public static Supplier<Optional<class_239>> crossHairTarget = Optional::empty;
    public static Runnable configChangeCallback = () -> {};
    private static final Supplier<PSConfig> CONFIG = Suppliers.memoize(() -> {
        PSConfig config = new PSConfig(FabricLoader.getInstance().getConfigDir().resolve("psychedelicraft.json"));
        try {
            config.load();
            config.onChangedExternally(cf -> configChangeCallback.run());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return config;
    });

    public static Optional<DrugProperties> getGlobalDrugProperties() {
        return globalDrugProperties.get();
    }

    public static Optional<class_239> getCrossHairTarget() {
        return crossHairTarget.get();
    }

    public static PSConfig getConfig() {
        return CONFIG.get();
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)DEFAULT_NAMESPACE, (String)name);
    }

    public void onInitialize() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> DrugProperties.of((class_1657)player).sendCapabilities());
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> DrugProperties.of((class_1657)newPlayer).copyFrom(DrugProperties.of((class_1657)oldPlayer), alive));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> DrugProperties.of((class_1657)handler.field_14140).sendCapabilities());
        PSBlockEntities.bootstrap();
        PSBlocks.bootstrap();
        PSItems.bootstrap();
        PSTags.bootstrap();
        PSItemGroups.bootstrap();
        PSFluids.bootstrap();
        PSRecipes.bootstrap();
        PSEntities.bootstrap();
        PSEffects.bootstrap();
        PSWorldGen.bootstrap();
        PSGameRules.bootstrap();
        PSCommands.bootstrap();
        PSSounds.bootstrap();
        PSScreenHandlers.bootstrap();
        Channel.bootstrap();
        PSCriteria.bootstrap();
        PSParticles.bootstrap();
        PSDamageTypes.bootstrap();
        VariantMarshal.bootstrap();
    }
}

