/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class PsychedelicraftMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Psychedelicraft");
    private static final String MIXIN_PACKAGE = "ivorius.psychedelicraft.mixin";
    private String sodiumPackage = "";
    private boolean hasSodium;
    private boolean hasIris;

    public void onLoad(String mixinPackage) {
        this.hasSodium = FabricLoader.getInstance().isModLoaded("sodium");
        this.hasIris = FabricLoader.getInstance().isModLoaded("iris");
        if (this.hasSodium) {
            this.sodiumPackage = this.isTargetAvailable("caffeinemc") ? "caffeinemc" : "jellysquid";
            LOGGER.info("Detected sodium package: " + this.sodiumPackage);
        }
        if (this.hasIris) {
            LOGGER.info("Detected iris");
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith(MIXIN_PACKAGE) && mixinClassName.indexOf("sodium") != -1) {
            return this.hasSodium && targetClassName.indexOf(this.sodiumPackage) != -1;
        }
        if (mixinClassName.startsWith(MIXIN_PACKAGE) && mixinClassName.indexOf(".iris.") != -1) {
            return this.hasIris;
        }
        return true;
    }

    private boolean isTargetAvailable(String target) {
        try {
            return Class.forName("net." + target + ".mods.sodium.client.SodiumClientMod") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

