/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.block.BlockWithFluid;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.block.entity.SyncedBlockEntity;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3902;
import net.minecraft.class_3913;
import net.minecraft.class_3919;
import net.minecraft.class_4538;
import net.minecraft.class_7225;

public class FlaskBlockEntity
extends SyncedBlockEntity
implements BlockWithFluid.DirectionalFluidResovoir,
Resovoir.ChangeListener,
PipeInsertable {
    private static final int[] INPUT_SLOT_ID = new int[]{0};
    private static final int[] OUTPUT_SLOT_ID = new int[]{1};
    private static final int[] BOTH_SLOT_ID = new int[]{0, 1};
    private final Resovoir tank;
    private boolean pendingSync;
    public final IoSlot inputSlot = new IoSlot(0);
    public final IoSlot outputSlot = new IoSlot(1);
    public final IoInventory ioInventory = new IoInventory(this);
    public final class_3913 propertyDelegate = new class_3919(this.getTotalProperties());

    public FlaskBlockEntity(class_2338 pos, class_2680 state) {
        this(PSBlockEntities.FLASK, pos, state, 648000);
    }

    public FlaskBlockEntity(class_2591<? extends FlaskBlockEntity> type, class_2338 pos, class_2680 state, int capacity) {
        super(type, pos, state);
        this.tank = new Resovoir(capacity, this);
    }

    public void markForUpdate() {
        this.pendingSync = true;
    }

    protected int getTotalProperties() {
        return 4;
    }

    @Override
    public void onLevelChange(Resovoir resovoir, int change) {
        this.markForUpdate();
    }

    @Override
    public Resovoir getPrimaryTank() {
        return this.tank;
    }

    @Override
    public void clientTick(class_1937 world) {
    }

    @Override
    public void tick(class_3218 world) {
        ItemFluids.Transaction t;
        int amount;
        class_1799 input;
        ItemFluids.Transaction t2;
        int amount2;
        class_1799 output = this.outputSlot.getStack();
        boolean playSound = false;
        if (FluidCapacity.get(output) > 0 && (amount2 = this.tank.withdraw(t2 = ItemFluids.Transaction.begin(output), 4050)) > 0) {
            this.outputSlot.incrementLevelsTransferred(amount2);
            playSound = true;
            this.outputSlot.setStack(t2.toItemStack());
        }
        if (FluidCapacity.get(input = this.inputSlot.getStack()) > 0 && (amount = this.tank.deposit(t = ItemFluids.Transaction.begin(input), 4050)) > 0) {
            this.inputSlot.incrementLevelsTransferred(amount);
            this.inputSlot.setStack(t.toItemStack());
            playSound = true;
        }
        if (playSound && world.method_8510() % 9L == 0L) {
            world.method_8396(null, this.method_11016(), class_3417.field_14978, class_3419.field_15245, 0.025f, 0.5f);
        }
        if (this.pendingSync) {
            this.pendingSync = false;
            this.method_5431();
            world.method_8408(this.method_11016(), this.method_11010().method_26204());
        }
    }

    @Override
    public boolean acceptsConnectionFrom(class_4538 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        return true;
    }

    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        Resovoir tank = this.getTankOnSide(direction);
        fluids.fluids().getFluids().stream().filter(i -> tank.getContents().canCombine((ItemFluids)i)).findFirst().ifPresent(f -> {
            int amountMoved = tank.deposit((ItemFluids)f);
            if (amountMoved > 0) {
                fluids.fluids().remove(f.ofAmount(amountMoved));
            }
        });
        return PipeInsertable.reject(fluids);
    }

    @Override
    public Optional<PipeInsertable.PipeFluids> tryExtract(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction) {
        Resovoir tank = this.getTankOnSide(direction);
        ItemFluids fluids = tank.drain((int)tank.getCapacity() / 10);
        return fluids.isEmpty() ? Optional.empty() : Optional.of(PipeInsertable.PipeFluids.of(fluids, Impurities.EMPTY, 0));
    }

    @Override
    @Deprecated
    public List<class_1799> getDroppedStacks(class_1799 container) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        int maxCapacity = Math.min(FluidCapacity.get(container), this.tank.getContents().amount());
        if (maxCapacity > 0) {
            stacks.add(ItemFluids.set(container, this.tank.getContents().ofAmount(maxCapacity)));
        }
        return stacks;
    }

    public void method_11007(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11007(compound, lookup);
        compound.method_10566("tank", (class_2520)this.tank.toNbt(lookup));
        class_1262.method_5426((class_2487)compound, (class_2371)this.ioInventory.field_5828, (class_7225.class_7874)lookup);
        compound.method_10566("inputSlot", (class_2520)this.inputSlot.toNbt(lookup));
        compound.method_10566("outputSlot", (class_2520)this.outputSlot.toNbt(lookup));
    }

    public void method_11014(class_2487 compound, class_7225.class_7874 lookup) {
        super.method_11014(compound, lookup);
        this.tank.fromNbt(compound.method_10562("tank"), lookup);
        class_1262.method_5429((class_2487)compound, (class_2371)this.ioInventory.field_5828, (class_7225.class_7874)lookup);
        this.inputSlot.fromNbt(compound.method_10562("inputSlot"), lookup);
        this.outputSlot.fromNbt(compound.method_10562("outputSlot"), lookup);
    }

    public int method_5439() {
        return this.ioInventory.method_5439();
    }

    public boolean method_5442() {
        return this.ioInventory.method_5442() && this.tank.getContents().isEmpty();
    }

    public class_1799 method_5438(int slot) {
        return this.ioInventory.method_5438(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.ioInventory.method_5434(slot, amount);
    }

    public class_1799 method_5441(int slot) {
        return this.ioInventory.method_5441(slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.ioInventory.method_5447(slot, stack);
        this.onContentsExternallyChanged(slot);
    }

    public void onContentsExternallyChanged(int slot) {
        if (slot == 0) {
            this.inputSlot.onChange();
        }
        if (slot == 1) {
            this.outputSlot.onChange();
        }
    }

    public boolean method_5443(class_1657 var1) {
        return true;
    }

    public void method_5448() {
        this.ioInventory.method_5448();
        this.tank.clear();
    }

    public int[] method_5494(class_2350 direction) {
        return switch (direction.method_10166()) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> INPUT_SLOT_ID;
            case class_2350.class_2351.field_11051 -> OUTPUT_SLOT_ID;
            case class_2350.class_2351.field_11052 -> BOTH_SLOT_ID;
        };
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return this.ioInventory.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        if (slot == OUTPUT_SLOT_ID[0] && this.outputSlot.getFillPercentage() >= 1.0f) {
            return true;
        }
        return slot == INPUT_SLOT_ID[0] && this.inputSlot.getFillPercentage() <= 0.0f;
    }

    public class IoSlot
    implements NbtSerialisable {
        public final int index;
        private final int levelsTransferredIndex;
        private final int inputtedLevelsIndex;

        public IoSlot(int index) {
            this.index = index;
            this.levelsTransferredIndex = 0 + index * 2;
            this.inputtedLevelsIndex = 1 + index * 2;
        }

        public float getProgress() {
            return FlaskBlockEntity.this.propertyDelegate.method_17390(this.inputtedLevelsIndex) == 0 ? 0.0f : (float)FlaskBlockEntity.this.propertyDelegate.method_17390(this.levelsTransferredIndex) / (float)FlaskBlockEntity.this.propertyDelegate.method_17390(this.inputtedLevelsIndex);
        }

        public void incrementLevelsTransferred(int amount) {
            FlaskBlockEntity.this.propertyDelegate.method_17391(this.levelsTransferredIndex, FlaskBlockEntity.this.propertyDelegate.method_17390(this.levelsTransferredIndex) + amount);
        }

        public void onChange() {
            class_1799 stack = FlaskBlockEntity.this.ioInventory.method_5438(this.index);
            ItemFluids fluids = ItemFluids.of(stack);
            int levels = fluids.amount();
            if (this.index == 1) {
                levels = FluidCapacity.get(stack) - levels;
            }
            FlaskBlockEntity.this.propertyDelegate.method_17391(this.inputtedLevelsIndex, levels);
            FlaskBlockEntity.this.propertyDelegate.method_17391(this.levelsTransferredIndex, 0);
        }

        public class_1799 getStack() {
            return FlaskBlockEntity.this.ioInventory.method_5438(this.index);
        }

        public void setStack(class_1799 stack) {
            FlaskBlockEntity.this.ioInventory.method_5447(this.index, stack);
        }

        public float getFillPercentage() {
            return FluidCapacity.getPercentage(this.getStack());
        }

        @Override
        public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
            compound.method_10569("inputtedLevels", FlaskBlockEntity.this.propertyDelegate.method_17390(this.inputtedLevelsIndex));
            compound.method_10569("levelsTransferred", FlaskBlockEntity.this.propertyDelegate.method_17390(this.levelsTransferredIndex));
        }

        @Override
        public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
            FlaskBlockEntity.this.propertyDelegate.method_17391(this.inputtedLevelsIndex, compound.method_10550("inputtedLevels"));
            FlaskBlockEntity.this.propertyDelegate.method_17391(this.levelsTransferredIndex, compound.method_10550("levelsTransferred"));
        }
    }

    class IoInventory
    extends class_1277 {
        public IoInventory(FlaskBlockEntity this$0) {
            super(2);
        }

        public int method_5444() {
            return 1;
        }

        public boolean method_5437(int slot, class_1799 stack) {
            return slot < this.method_5439() && FluidCapacity.get(stack) > 0 && (slot == 0 ? FluidCapacity.getPercentage(stack) > 0.0f : FluidCapacity.getPercentage(stack) < 1.0f);
        }
    }
}

