/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity.contents;

import com.mojang.datafixers.util.Either;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.BlockWithFluid;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.ShapeUtil;
import ivorius.psychedelicraft.block.entity.BurnerBlockEntity;
import ivorius.psychedelicraft.block.entity.contents.EmptyContents;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.ItemFluidsMixture;
import ivorius.psychedelicraft.recipe.BunsenBurnerRecipe;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ItemMound;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5328;
import net.minecraft.class_7225;

public class SmallContents
implements BurnerBlockEntity.CraftableContents,
BlockWithFluid.DirectionalFluidResovoir,
Resovoir.ChangeListener {
    public static final class_2960 ID = Psychedelicraft.id("small");
    protected List<Resovoir> auxiliaryTanks = new ArrayList<Resovoir>();
    private static final class_265 SHAPE = ShapeUtil.createCenteredShape(1.5, 8.0, 1.5);
    protected int capacity;
    protected final BurnerBlockEntity entity;

    public SmallContents(BurnerBlockEntity entity, int capacity, class_1799 stack) {
        this.entity = entity;
        this.capacity = capacity;
        this.auxiliaryTanks.add(this.createTank());
        this.loadContents(stack);
    }

    @Override
    public int getTotalFluidVolume() {
        return BurnerBlockEntity.CraftableContents.super.getTotalFluidVolume();
    }

    @Override
    public class_265 getOutlineShape() {
        return SHAPE;
    }

    protected void loadContents(class_1799 stack) {
        this.getPrimaryTank().deposit(ItemFluids.of(stack));
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    protected Resovoir createTank() {
        return new Resovoir(this.capacity, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLevelChange(Resovoir resovoir, int change) {
        this.method_5431();
        if (change > 0) {
            this.entity.setTemperature(this.entity.getTemperature() / 2);
        }
        if (resovoir.getContents().isEmpty()) {
            List<Resovoir> list = this.auxiliaryTanks;
            synchronized (list) {
                this.auxiliaryTanks.removeIf(r -> r.getContents().isEmpty());
                if (this.auxiliaryTanks.isEmpty()) {
                    this.auxiliaryTanks.add(this.createTank());
                }
            }
        }
        if (change > 0) {
            this.entity.method_10997().method_45447(null, this.entity.method_11016(), class_3417.field_14779, class_3419.field_15245);
        }
    }

    @Override
    public Optional<BurnerBlockEntity.Contents> interact(class_1799 stack, class_1657 player, class_1268 hand, class_2350 side) {
        if (stack.method_7960()) {
            if (!player.method_37908().field_9236) {
                player.method_6122(hand, ItemFluidsMixture.set(this.entity.getContainer(), this.getAuxiliaryTanks().stream().map(Resovoir::getContents).toList()));
                this.entity.setContainer(class_1799.field_8037);
                for (class_1799 ingredient : this.getCraftingIngredients().convertToItemStacks()) {
                    if (player.method_7270(stack)) continue;
                    class_2248.method_9577((class_1937)player.method_37908(), (class_2338)this.entity.method_11016(), (class_1799)ingredient);
                }
                this.method_5448();
            }
            this.entity.playSound(player, class_3417.field_15197);
            return Optional.of(new EmptyContents(this.entity));
        }
        if (FluidCapacity.get(stack) > 0) {
            return this.interactWithFluidVessel(stack, player, hand, side);
        }
        return Optional.empty();
    }

    protected Optional<BurnerBlockEntity.Contents> interactWithFluidVessel(class_1799 stack, class_1657 player, class_1268 hand, class_2350 side) {
        ItemFluids.Transaction t = ItemFluids.Transaction.begin(stack);
        if (!t.fluids().isEmpty() && this.getPrimaryTank().deposit(t, t.fluids().amount()) > 0) {
            this.entity.playSound(player, class_3417.field_14826);
            if (!player.method_37908().field_9236) {
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)t.toItemStack()));
            }
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public Either<PipeInsertable.PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeInsertable.PipeFluids fluids) {
        if (direction != class_2350.field_11033) {
            return PipeInsertable.reject(fluids);
        }
        FluidMound remainder = FluidMound.of(fluids.fluids());
        fluids.fluids().getFluids().forEach(fluid -> {
            int transferred = this.getPrimaryTank().deposit((ItemFluids)fluid);
            if (transferred > 0) {
                remainder.remove(fluid.ofAmount(transferred));
            }
        });
        return PipeInsertable.reject(fluids.withFluids(remainder));
    }

    @Override
    public void clientTick(class_1937 world) {
    }

    @Override
    public void tick(class_3218 world) {
    }

    @Override
    public ItemMound getCraftingIngredients() {
        return new ItemMound();
    }

    @Override
    public void onCraft(BunsenBurnerRecipe.Input input) {
    }

    @Override
    public void produceProducts(class_3218 world, class_2338 pipePos, BunsenBurnerRecipe.Product product) {
        if (!product.items().isEmpty()) {
            class_2248.method_9577((class_1937)world, (class_2338)this.entity.method_11016(), (class_1799)product.items().removeFirst());
        }
        ItemFluids fluid = product.fluids().split(100);
        this.getPrimaryTank().drain(fluid.amount());
        if (!PipeInsertable.tryInsert(world, pipePos, class_2350.field_11036, PipeInsertable.PipeFluids.of(fluid, new Impurities(product.impurities()), 15)).equals((Object)STATUS_ACCEPT_ALL)) {
            this.onFluidWasted(world);
        }
    }

    public void method_5431() {
        this.entity.method_5431();
    }

    protected void onFluidWasted(class_3218 world) {
        world.method_65096((class_2394)class_2398.field_46763, (double)((float)this.entity.method_11016().method_10263() + world.method_8409().method_62816(0.5f, 0.1f)), (double)((float)this.entity.method_11016().method_10264() + 0.6f), (double)((float)this.entity.method_11016().method_10260() + world.method_8409().method_62816(0.5f, 0.1f)), 2, 0.0, 0.0, 0.0, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resovoir getPrimaryTank() {
        List<Resovoir> list = this.auxiliaryTanks;
        synchronized (list) {
            if (this.auxiliaryTanks.isEmpty()) {
                this.auxiliaryTanks.add(this.createTank());
            }
            return this.auxiliaryTanks.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resovoir getLastTank() {
        List<Resovoir> list = this.auxiliaryTanks;
        synchronized (list) {
            return this.auxiliaryTanks.isEmpty() ? this.getPrimaryTank() : this.auxiliaryTanks.get(this.auxiliaryTanks.size() - 1);
        }
    }

    @Override
    public Resovoir getTankOnSide(class_2350 direction) {
        return this.getPrimaryTank();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Resovoir> getAuxiliaryTanks() {
        List<Resovoir> list = this.auxiliaryTanks;
        synchronized (list) {
            return new ArrayList<Resovoir>(this.auxiliaryTanks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5448() {
        List<Resovoir> list = this.auxiliaryTanks;
        synchronized (list) {
            this.auxiliaryTanks.clear();
        }
        this.method_5431();
    }

    @Override
    public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10569("capacity", this.capacity);
        compound.method_10566("fluids", (class_2520)NbtSerialisable.fromList(this.getAuxiliaryTanks(), lookup));
    }

    @Override
    public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.capacity = compound.method_10550("capacity");
        this.auxiliaryTanks = NbtSerialisable.toList(new ArrayList(), compound.method_10554("fluids", 10), lookup, this::createTank);
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    public int method_5439() {
        return 0;
    }

    @Override
    public boolean method_5442() {
        return this.getTotalFluidVolume() == 0;
    }

    public class_1799 method_5438(int slot) {
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1799.field_8037;
    }

    public class_1799 method_5441(int slot) {
        return class_1799.field_8037;
    }

    public void method_5447(int slot, class_1799 stack) {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<class_1799> getDroppedStacks(class_1799 container) {
        if (!this.method_5442()) {
            List<Resovoir> list = this.auxiliaryTanks;
            synchronized (list) {
                if (this.auxiliaryTanks.size() == 1) {
                    return List.of(ItemFluids.set(container.method_7972(), this.getPrimaryTank().getContents()));
                }
                return List.of(ItemFluidsMixture.set(container.method_7972(), this.auxiliaryTanks.stream().map(Resovoir::getContents).toList()));
            }
        }
        return List.of(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public class_1799 getFilled(class_1799 container, boolean dryRun, float drainPercentage) {
        if (!this.method_5442()) {
            List<Resovoir> list = this.auxiliaryTanks;
            synchronized (list) {
                if (this.auxiliaryTanks.size() == 1) {
                    return ItemFluids.set(container.method_7972(), this.copyOrWithdraw(this.getPrimaryTank(), dryRun, drainPercentage));
                }
                return ItemFluidsMixture.set(container.method_7972(), this.auxiliaryTanks.stream().map(tank -> this.copyOrWithdraw((Resovoir)tank, dryRun, drainPercentage)).toList());
            }
        }
        return container;
    }

    private ItemFluids copyOrWithdraw(Resovoir tank, boolean dryRun, float drainPercentage) {
        int amount = class_3532.method_15386((float)((float)tank.getContents().amount() * drainPercentage));
        return dryRun ? tank.getContents().ofAmount(Math.min(amount, tank.getContents().amount())) : tank.drain(amount);
    }
}

