/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class GLStateProxy {
    public static final int DEFAULT_TEXTURE = 33984;
    public static final int LIGHTMAP_TEXTURE = 33985;
    private static final class_1060 TEXURE_MANAGER = class_310.method_1551().method_1531();
    private static boolean usesScreenTexCoords;
    private static boolean resolutionSet;
    private static final float[] resolution;

    public static boolean isColorSafeMode() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL11.glIsEnabled((int)3042) && GLStateProxy.getBlendDFactor() != 771;
    }

    private static int getBlendDFactor() {
        RenderSystem.assertOnRenderThreadOrInit();
        return GL14.glGetInteger((int)32968);
    }

    public static void setResolution(float width, float height) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> GLStateProxy._setResolution(width, height));
        } else {
            GLStateProxy._setResolution(width, height);
        }
    }

    private static void _setResolution(float width, float height) {
        GLStateProxy.resolution[0] = 1.0f / width;
        GLStateProxy.resolution[1] = 1.0f / height;
        resolutionSet = true;
    }

    public static float[] getResolution() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (!resolutionSet) {
            class_1041 window = class_310.method_1551().method_22683();
            GLStateProxy.resolution[0] = 1.0f / (float)window.method_4489();
            GLStateProxy.resolution[1] = 1.0f / (float)window.method_4506();
        }
        return resolution;
    }

    public static void clearResolution() {
        RenderSystem.assertOnRenderThreadOrInit();
        resolutionSet = false;
    }

    public static void enableTexCoords() {
        RenderSystem.assertOnRenderThreadOrInit();
        usesScreenTexCoords = true;
    }

    public static void disableScreenTexCoords() {
        RenderSystem.assertOnRenderThreadOrInit();
        usesScreenTexCoords = false;
    }

    public static boolean getUsesScreenTexCoords() {
        return usesScreenTexCoords;
    }

    public static int getTextureId(class_2960 texture) {
        RenderSystem.assertOnRenderThreadOrInit();
        return TEXURE_MANAGER.method_4619(texture).method_4624();
    }

    static {
        resolution = new float[2];
    }

    public static enum ShadeMode {
        FLAT,
        SMOOTH;

    }
}

