/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.shader;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntSupplier;
import net.minecraft.class_10157;
import net.minecraft.class_284;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30C;

public class BuiltGemoetryShader {
    private final int program;
    private final List<class_284> uniforms;
    private final List<Sampler> samplers;

    public BuiltGemoetryShader(int program, List<class_284> uniforms, List<Sampler> samplers) {
        this.program = program;
        this.uniforms = uniforms;
        this.samplers = samplers;
    }

    public void bind() {
        for (Sampler sampler : this.samplers) {
            sampler.bind(this.program);
        }
        for (class_284 uniform : this.uniforms) {
            uniform.method_1300();
        }
    }

    private static class Sampler {
        private final int id;
        public int location;
        private final String name;
        private final IntSupplier valueGetter;

        public Sampler(int id, String name, IntSupplier valueGetter) {
            this.id = id;
            this.name = name;
            this.valueGetter = valueGetter;
        }

        void bind(int program) {
            int texId = this.valueGetter.getAsInt();
            GL30C.glUniform1i((int)this.location, (int)this.id);
            RenderSystem.activeTexture((int)(33984 + this.id));
            RenderSystem.bindTexture((int)texId);
        }
    }

    public static class Builder {
        private final List<class_284> uniforms = new ArrayList<class_284>();
        private final List<Sampler> samplers = new ArrayList<Sampler>();
        private final int program;
        private int lastFragmentId;

        public Builder(int program, int lastAttributeId, int lastFragmentId) {
            this.program = program;
            this.lastFragmentId = lastFragmentId;
        }

        void addSampler(class_10157.class_10158 sampler, IntSupplier supplier) {
            this.samplers.add(new Sampler(++this.lastFragmentId, sampler.comp_3121(), supplier));
        }

        void addUniform(class_284 uniform) {
            this.uniforms.add(uniform);
        }

        public BuiltGemoetryShader build() {
            ArrayList<Sampler> samplers = new ArrayList<Sampler>();
            this.samplers.forEach(sampler -> {
                int location = GL20C.glGetUniformLocation((int)this.program, (CharSequence)sampler.name);
                if (location != -1) {
                    sampler.location = location;
                    samplers.add((Sampler)sampler);
                }
            });
            ArrayList<class_284> uniforms = new ArrayList<class_284>();
            this.uniforms.forEach(uniform -> {
                int location = GL20C.glGetUniformLocation((int)this.program, (CharSequence)uniform.method_1298());
                if (location != -1) {
                    uniforms.add((class_284)uniform);
                    uniform.method_1297(location);
                }
            });
            return new BuiltGemoetryShader(this.program, uniforms, samplers);
        }
    }

    public static interface Holder {
        public void attachUniformData(@Nullable BuiltGemoetryShader var1);
    }
}

