/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.datagen.providers;

import com.google.common.base.Preconditions;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.BurnerBlock;
import ivorius.psychedelicraft.block.GlassTubeBlock;
import ivorius.psychedelicraft.block.ValveBlock;
import ivorius.psychedelicraft.client.item.VatItemModelRenderer;
import ivorius.psychedelicraft.datagen.providers.ItemModels;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10410;
import net.minecraft.class_10515;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5794;
import net.minecraft.class_7923;

public interface BlockModels {
    public static final class_4945 CONNECTION = class_4945.method_27043((String)"connection");
    public static final class_4942 VINE_CONNECTION_TEMPLATE = BlockModels.block("vine_connection_template", CONNECTION);
    public static final class_4945 LATTICE = class_4945.method_27043((String)"lattice");
    public static final class_4942 CROP_LATTICE_TEMPLATE = BlockModels.block("crop_lattice_template", LATTICE, class_4945.field_22999);
    public static final class_4942 LATTICE_TEMPLATE = BlockModels.block("lattice_template", LATTICE);
    public static final class_2960 COMPLEX_BLOCK_ID = Psychedelicraft.id("block/complex_block");
    public static final class_4942 COMPLEX_BLOCK = BlockModels.block("complex_block", class_4945.field_23011, class_4945.field_23012);
    public static final class_4942 VAT_TEMPLATE = BlockModels.block("vat_template", class_4945.field_23010);
    public static final class_4942 TRAY_TEMPLATE = BlockModels.block("tray_template", class_4945.field_23010);
    public static final class_4942 DRYING_TABLE_TEMPLATE = BlockModels.block("drying_table_template", class_4945.field_23014, class_4945.field_23018, class_4945.field_23015);
    public static final class_4942 BUNSEN_BURNER = BlockModels.block("bunsen_burner", class_4945.field_23014);
    public static final class_4946.class_4947 VAT = class_4946.method_25918(class_4944::method_25864, (class_4942)VAT_TEMPLATE);
    public static final class_4946.class_4947 DRYING_TABLE = class_4946.method_25918(block -> class_4944.method_25898((class_2248)block), (class_4942)DRYING_TABLE_TEMPLATE);

    public static class_4942 block(String parent, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(Psychedelicraft.id("block/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    public static void registerSpecialItemModel(class_4910 generator, class_2248 block, class_2960 parent, class_10515.class_10516 unbaked) {
        generator.field_55238.method_65460(block.method_8389(), class_10410.method_65482((class_2960)parent, (class_10515.class_10516)unbaked));
    }

    public static void generateWoodset(class_4910 generator, class_5794 family, class_2248 log, class_2248 wood, class_2248 strippedLog, class_2248 strippedWood, class_2248 hangingSign, class_2248 wallHangingSign, class_2248 leaves, class_2248 sapling, class_2248 pottedSapling) {
        generator.method_25676(log).method_25730(log).method_25728(wood);
        generator.method_25676(strippedLog).method_25730(strippedLog).method_25728(strippedWood);
        generator.method_25650(family.method_33469()).method_33522(family);
        generator.method_46190(strippedLog, hangingSign, wallHangingSign);
        generator.method_25622(leaves, class_4946.field_23049);
        generator.method_25545(sapling, pottedSapling, class_4910.class_4913.field_22840);
    }

    public static void registerParentedWithoutItem(class_4910 generator, class_2248 modelSource, class_2248 child) {
        class_2960 modelId = class_4941.method_25842((class_2248)modelSource);
        generator.field_22830.accept(class_4925.method_25770((class_2248)child, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId)));
    }

    public static void registerBarrel(class_4910 generator, class_2248 block) {
        class_2960 planksId = class_7923.field_41175.method_10221((Object)block).method_45134(p -> p.replace("_barrel", "_planks"));
        generator.method_65403(block, class_7923.field_41175.method_17966(planksId).or(() -> class_7923.field_41175.method_17966(class_2960.method_60656((String)planksId.method_12832()))).orElse(class_2246.field_10161));
        generator.method_25537(block.method_8389());
    }

    public static BiConsumer<SimpleFluid, String> createFluidCollector(class_4910 generator) {
        Function appearances = class_156.method_34866(appearance -> {
            class_2960 id = Psychedelicraft.id("block/fluid/" + String.valueOf(appearance));
            return class_4943.field_22908.method_25852(id, class_4944.method_25891((class_2960)id.method_48331("_still")), generator.field_22831);
        });
        return (fluid, appearance) -> generator.field_22830.accept(class_4910.method_25644((class_2248)fluid.getPhysical().getBlock(), (class_2960)((class_2960)appearances.apply(appearance))));
    }

    public static void registerCrossCrop(class_4910 generator, class_2248 crop, class_2769<Integer> ageProperty, int ... ageTextureIndices) {
        BlockModels.registerCrossCrop(generator, BlockModels.createCropModelSupplier(generator, crop), crop, ageProperty, ageTextureIndices);
    }

    public static Function<Integer, class_2960> createCropModelSupplier(class_4910 generator, class_2248 crop) {
        return BlockModels.createCropModelSupplier(generator, class_4943.field_22921, class_4944::method_25880, crop);
    }

    public static Function<Integer, class_2960> createCropModelSupplier(class_4910 generator, class_4942 model, Function<class_2960, class_4944> textures, class_2248 crop) {
        return class_156.method_34866(i -> generator.method_25557(crop, "_stage" + i, model, textures));
    }

    public static void registerCrossCrop(class_4910 generator, Function<Integer, class_2960> models, class_2248 crop, class_2769<Integer> ageProperty, int ... ageTextureIndices) {
        Preconditions.checkArgument((ageProperty.method_11898().size() == ageTextureIndices.length ? 1 : 0) != 0);
        generator.method_25537(crop.method_8389());
        generator.field_22830.accept(class_4925.method_25769((class_2248)crop).method_25775(class_4926.method_25783(ageProperty).method_25795(integer -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)((class_2960)models.apply(ageTextureIndices[integer]))))));
    }

    public static <T extends Comparable<T>> void registerCrossCrop(class_4910 generator, class_2248 crop, class_2769<Integer> ageProperty, class_2769<T> partProperty, Function<T, String> partNameFunction, int ... ageTextureIndices) {
        BlockModels.registerCrossCrop(generator, crop, ageProperty, partProperty, partNameFunction, part -> ageTextureIndices);
    }

    public static <T extends Comparable<T>> void registerCrossCrop(class_4910 generator, class_2248 crop, class_2769<Integer> ageProperty, class_2769<T> partProperty, Function<T, String> partNameFunction, Function<T, int[]> ageTextureIndicesFunction) {
        BiFunction models = class_156.method_34865((age, part) -> generator.method_25557(crop, (String)partNameFunction.apply(part) + "_stage" + age, class_4943.field_22921, class_4944::method_25880));
        Function textureIndices = class_156.method_34866(part -> {
            int[] indices = (int[])ageTextureIndicesFunction.apply(part);
            Preconditions.checkArgument((ageProperty.method_11898().size() == indices.length ? 1 : 0) != 0);
            return indices;
        });
        class_4925 states = class_4925.method_25769((class_2248)crop).method_25775(class_4926.method_25784(ageProperty, partProperty).method_25800((age, part) -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)((class_2960)models.apply(((int[])textureIndices.apply(part))[age], part)))));
        generator.method_25537(crop.method_8389());
        generator.field_22830.accept(states);
    }

    public static void registerVineCrop(class_4910 generator, class_2248 crop, class_2769<Integer> ageProperty, int ... ageTextureIndices) {
        Preconditions.checkArgument((ageProperty.method_11898().size() == ageTextureIndices.length ? 1 : 0) != 0);
        Function<Integer, class_2960> models = BlockModels.createCropModelSupplier(generator, crop);
        class_2960 connectionModelId = generator.method_25557(crop, "_connection", VINE_CONNECTION_TEMPLATE, id -> class_4944.method_25883((class_4945)CONNECTION, (class_2960)id));
        generator.method_25537(crop.method_8389());
        generator.field_22830.accept(((class_4922)class_156.method_654((Object)class_4922.method_25758((class_2248)crop), states -> ageProperty.method_11898().forEach(age -> states.method_25760((class_4918)class_4918.method_25744().method_25751(ageProperty, (Comparable)age), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)((class_2960)models.apply(ageTextureIndices[age]))))))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)connectionModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)connectionModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)connectionModelId)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)connectionModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)));
    }

    public static void registerLatticeCrop(class_4910 generator, class_2248 lattice, class_2248 crop, class_2769<Integer> ageProperty, int ... ageTextureIndices) {
        Function<Integer, class_2960> models = BlockModels.createCropModelSupplier(generator, CROP_LATTICE_TEMPLATE, id -> class_4944.method_25883((class_4945)LATTICE, (class_2960)class_4944.method_25860((class_2248)lattice)).method_25868(class_4945.field_22999, id), crop);
        generator.field_22830.accept((class_4917)class_156.method_654((Object)class_4922.method_25758((class_2248)crop), states -> ageProperty.method_11898().forEach(age -> BlockModels.addLatticeStates(states, () -> class_4918.method_25744().method_25751(ageProperty, (Comparable)age), (class_2960)models.apply((Integer)age)))));
    }

    public static void registerLattice(class_4910 generator, class_2248 lattice) {
        class_4944 textures = class_4944.method_25883((class_4945)LATTICE, (class_2960)class_4944.method_25860((class_2248)lattice));
        class_2960 model = LATTICE_TEMPLATE.method_25846(lattice, textures, generator.field_22831);
        generator.field_22830.accept(BlockModels.addLatticeStates(class_4922.method_25758((class_2248)lattice), class_4918::method_25744, model));
        ItemModels.LATTICE_TEMPLATE.method_25852(class_4941.method_25840((class_1792)lattice.method_8389()), textures, generator.field_22831);
    }

    public static class_4922 addLatticeStates(class_4922 states, Supplier<class_4918.class_4921> when, class_2960 model) {
        return states.method_25760((class_4918)when.get().method_25751((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)when.get().method_25751((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)when.get().method_25751((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22888, (Object)true)).method_25760((class_4918)when.get().method_25751((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893).method_25828(class_4936.field_22888, (Object)true));
    }

    public static void registerCropPot(class_4910 generator, class_2248 plantBlock, class_2248 flowerPotBlock, class_4910.class_4913 tintType, String suffix) {
        class_4944 textureMap = class_4944.method_25884((class_2960)class_4944.method_25866((class_2248)plantBlock, (String)suffix));
        class_2960 identifier = tintType.method_25727().method_25846(flowerPotBlock, textureMap, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)flowerPotBlock, (class_2960)identifier));
    }

    public static void registerBunsenBurner(class_4910 generator, class_2248 block) {
        class_2960 modelId = class_4941.method_25842((class_2248)block);
        class_2960 litModelId = BUNSEN_BURNER.method_25852(class_4941.method_25843((class_2248)block, (String)"_lit"), class_4944.method_25883((class_4945)class_4945.field_23014, (class_2960)class_4944.method_25866((class_2248)block, (String)"_base_lit")), generator.field_22831);
        generator.method_25623(block, modelId);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)BurnerBlock.LIT, (class_2960)litModelId, (class_2960)modelId)));
    }

    public static void registerTray(class_4910 generator, class_2248 tray) {
        class_2960 modelId = TRAY_TEMPLATE.method_25846(tray, class_4944.method_25864((class_2248)tray), generator.field_22831);
        generator.method_25623(tray, modelId);
        generator.field_22830.accept(class_4925.method_25770((class_2248)tray, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId)).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12529).method_25793((Comparable)class_2350.class_2351.field_11048, class_4935.method_25824().method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.class_2351.field_11051, class_4935.method_25824())));
    }

    public static void registerDistillery(class_4910 generator, class_2248 block) {
        class_2960 modelId = class_4941.method_25842((class_2248)block);
        class_2960 condenserModelId = class_4941.method_25843((class_2248)block, (String)"_condenser");
        generator.field_22830.accept(class_4922.method_25758((class_2248)block).method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11034), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)condenserModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)condenserModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11035), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)condenserModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11039), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)condenserModelId).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)));
        generator.method_25623(block, modelId);
    }

    public static void registerVat(class_4910 generator, class_2248 core, class_2248 edge, class_2248 materialBase) {
        generator.method_25660(edge, class_4941.method_25842((class_2248)materialBase));
        generator.method_25622(core, VAT);
        generator.method_65409(core, (class_10515.class_10516)new VatItemModelRenderer.Unbaked());
    }

    public static void registerDryingTable(class_4910 generator, class_2248 block) {
        generator.method_25622(block, DRYING_TABLE);
        generator.method_25623(block, class_4941.method_25842((class_2248)block));
    }

    public static void registerTubing(class_4910 generator, class_2248 block) {
        class_4922 states = class_4922.method_25758((class_2248)block);
        BlockModels.addPipeConnectionStates(states, GlassTubeBlock.IN, class_4941.method_25843((class_2248)block, (String)"_in"), () -> class_4918.method_25744());
        BlockModels.addPipeConnectionStates(states, GlassTubeBlock.OUT, class_4941.method_25843((class_2248)block, (String)"_out"), () -> class_4918.method_25744());
        BlockModels.addPipeExtensionStates(states, GlassTubeBlock.IN, GlassTubeBlock.EXTENDED_IN, class_4941.method_25842((class_2248)block));
        BlockModels.addPipeExtensionStates(states, GlassTubeBlock.OUT, GlassTubeBlock.EXTENDED_OUT, class_4941.method_25842((class_2248)block));
        generator.field_55238.method_65460(block.method_8389(), class_10410.method_65481((class_2960)class_4943.field_22940.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)block.method_8389())), generator.field_22831)));
        generator.field_22830.accept(states);
    }

    public static void registerTubingWithTap(class_4910 generator, class_2248 tube, class_2248 block) {
        class_4922 states = class_4922.method_25758((class_2248)block);
        BlockModels.addPipeConnectionStates(states, GlassTubeBlock.IN, class_4941.method_25843((class_2248)tube, (String)"_in"), () -> class_4918.method_25744());
        BlockModels.addPipeConnectionStates(states, GlassTubeBlock.OUT, class_4941.method_25843((class_2248)tube, (String)"_out"), () -> class_4918.method_25744());
        BlockModels.addPipeExtensionStates(states, GlassTubeBlock.IN, GlassTubeBlock.EXTENDED_IN, class_4941.method_25842((class_2248)tube));
        BlockModels.addPipeExtensionStates(states, GlassTubeBlock.OUT, GlassTubeBlock.EXTENDED_OUT, class_4941.method_25842((class_2248)tube));
        states.method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)ValveBlock.OPEN, (Comparable)Boolean.valueOf(true)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)block, (String)"_open"))).method_25760((class_4918)class_4918.method_25744().method_25751((class_2769)ValveBlock.OPEN, (Comparable)Boolean.valueOf(false)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)block, (String)"_closed")));
        generator.field_55238.method_65460(block.method_8389(), class_10410.method_65481((class_2960)class_4943.field_22940.method_25852(class_4941.method_25840((class_1792)block.method_8389()), class_4944.method_25895((class_2960)class_4944.method_25876((class_1792)block.method_8389())), generator.field_22831)));
        generator.field_22830.accept(states);
    }

    public static void registerPump(class_4910 generator, class_2248 block) {
        class_2960 normal = class_4941.method_25842((class_2248)block);
        class_2960 powered = class_4941.method_25843((class_2248)block, (String)"_extended");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25565((class_2746)class_2741.field_12484, (class_2960)powered, (class_2960)normal)).method_25775(class_4910.method_25640()));
        generator.method_25623(block, normal);
    }

    public static void registerPumpHead(class_4910 generator, class_2248 block) {
        class_2960 normal = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)normal)).method_25775(class_4910.method_25640()));
    }

    public static class_4922 addPipeExtensionStates(class_4922 states, class_2754<GlassTubeBlock.IODirection> property, class_2746 extensionProperty, class_2960 model) {
        return BlockModels.addPipeConnectionStates(states, property, model.method_48331("_extension"), () -> class_4918.method_25744().method_25751((class_2769)extensionProperty, (Comparable)Boolean.valueOf(true)));
    }

    public static class_4922 addPipeConnectionStates(class_4922 states, class_2754<GlassTubeBlock.IODirection> property, class_2960 model, Supplier<class_4918.class_4921> when) {
        return states.method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.UP)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.DOWN)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22890).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890)).method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.EAST)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.WEST)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.NORTH)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760((class_4918)when.get().method_25751(property, (Comparable)((Object)GlassTubeBlock.IODirection.SOUTH)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22891).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22890));
    }
}

