/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.datagen.providers.recipe;

import ivorius.psychedelicraft.datagen.providers.recipe.FluidRecipeJsonBuilder;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.MashingRecipe;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2096;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class MashingRecipeJsonBuilder
implements FluidRecipeJsonBuilder {
    static final ItemFluids.Predicate WATER_PREDICATE = ItemFluids.Predicate.builder().fluid(SimpleFluid.of((class_3611)class_3612.field_15910)).amount(class_2096.class_2100.method_9053((int)182250)).build();
    private final class_7871<class_1792> lookup;
    private final class_7800 category;
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private ItemFluids.Predicate baseFluid = WATER_PREDICATE;
    private final ItemFluids output;
    private int stewTime;
    private final List<MashingRecipe.Ingredients.Entry> ingredients = new ArrayList<MashingRecipe.Ingredients.Entry>();

    private MashingRecipeJsonBuilder(class_7871<class_1792> lookup, class_7800 category, ItemFluids output) {
        this.lookup = lookup;
        this.category = category;
        this.output = output;
    }

    public static MashingRecipeJsonBuilder create(class_7871<class_1792> lookup, class_7800 category, ItemFluids output) {
        return new MashingRecipeJsonBuilder(lookup, category, output);
    }

    public MashingRecipeJsonBuilder criterion(String name, class_175<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public MashingRecipeJsonBuilder base(ItemFluids.Predicate.Builder builder) {
        this.baseFluid = builder.build();
        return this;
    }

    public MashingRecipeJsonBuilder input(class_6862<class_1792> tag, int count) {
        return this.input(class_1856.method_8106((class_6885)this.lookup.method_46735(tag)), count);
    }

    public MashingRecipeJsonBuilder input(class_1935 input, int count) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{input}), count);
    }

    public MashingRecipeJsonBuilder input(class_1935 input) {
        return this.input(input, 1);
    }

    public MashingRecipeJsonBuilder input(class_1856 input) {
        return this.input(input, 1);
    }

    public MashingRecipeJsonBuilder input(class_1856 input, int count) {
        this.ingredients.add(new MashingRecipe.Ingredients.Entry(Optional.of(input), count));
        return this;
    }

    public MashingRecipeJsonBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public MashingRecipeJsonBuilder stewTime(int stewTime) {
        this.stewTime = stewTime;
        return this;
    }

    @Override
    public ItemFluids getOutputFluids() {
        return this.output;
    }

    public void method_17972(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
        recipeKey = class_5321.method_29179((class_5321)recipeKey.method_58273(), (class_2960)recipeKey.method_29177().method_48331("_from_mashing"));
        this.validate(recipeKey);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_5321)recipeKey)).method_703(class_170.class_171.method_753((class_5321)recipeKey)).method_704(class_8782.class_8797.field_1257);
        this.criteria.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        exporter.method_53819(recipeKey, (class_1860)new MashingRecipe(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308((class_7800)this.category), this.baseFluid, this.output, new MashingRecipe.Ingredients((List<MashingRecipe.Ingredients.Entry>)class_2371.method_10212((Object)MashingRecipe.Ingredients.Entry.EMPTY, (Object[])((MashingRecipe.Ingredients.Entry[])this.ingredients.toArray(MashingRecipe.Ingredients.Entry[]::new)))), this.stewTime), builder.method_695(recipeKey.method_29177().method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private void validate(class_5321<class_1860<?>> recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey));
        }
        Objects.requireNonNull(this.output, "Mashing recipe has no output");
    }
}

