/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.GluttonyManager;
import ivorius.psychedelicraft.entity.drug.LockableHungerManager;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.BagContentsComponent;
import ivorius.psychedelicraft.util.NbtSerialisable;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public class Stomach
implements NbtSerialisable {
    private final DrugProperties properties;
    private int vomitCount;
    private int vomitCooldown;
    private int vomitingTicks;
    private int hungerCooldown;
    private int previousFoodLevel;
    private final class_1657 entity;

    public Stomach(DrugProperties properties) {
        this.properties = properties;
        this.entity = properties.asEntity();
    }

    public boolean reset() {
        boolean changed = this.getStomach().getLockedState() != null || this.getGlut().getOvereating() > 0.0f || this.vomitingTicks > 0;
        this.getStomach().unlockHunger();
        this.getGlut().setOvereating(0.0f);
        this.vomitCount = 0;
        this.vomitCooldown = 0;
        this.hungerCooldown = 0;
        this.vomitingTicks = 0;
        this.properties.markDirty();
        return changed;
    }

    public void copyFrom(Stomach old, boolean alive) {
        if (alive) {
            this.vomitCount = old.vomitCount;
            this.vomitCooldown = old.vomitCooldown;
            this.vomitingTicks = old.vomitingTicks;
            this.hungerCooldown = old.hungerCooldown;
            this.previousFoodLevel = old.previousFoodLevel;
            this.getStomach().setLockedState(old.getStomach().getLockedState());
            this.getGlut().setOvereating(old.getGlut().getOvereating());
        } else {
            this.reset();
        }
    }

    public LockableHungerManager getStomach() {
        return (LockableHungerManager)this.entity.method_7344();
    }

    public GluttonyManager getGlut() {
        return (GluttonyManager)this.entity.method_7344();
    }

    public int getCooldown() {
        return this.getStomach().getLockedState() == null ? 0 : this.hungerCooldown;
    }

    public int setVisibleState(int ticks) {
        boolean shaking;
        boolean bl = shaking = this.vomitingTicks > 0 || this.getGlut().getOvereating() > 8.0f || this.getStomach().getLockedState() != null && (this.getStomach().getActualFoodLevel() <= 3 || this.getStomach().getActualFoodLevel() != this.previousFoodLevel || this.hungerCooldown < 50);
        if (shaking) {
            this.getStomach().setShanksShaking(true);
            return 0;
        }
        return ticks;
    }

    public void onTick() {
        this.previousFoodLevel = this.getStomach().getActualFoodLevel();
        float hungerSuppression = class_3532.method_15363((float)this.properties.getModifier(Drug.HUNGER_SUPPRESSION), (float)-1.0f, (float)1.0f);
        boolean shouldLockHunger = Math.abs(hungerSuppression) > 1.0E-5f;
        if (shouldLockHunger != (this.getStomach().getLockedState() != null)) {
            if (shouldLockHunger) {
                this.hungerCooldown = 120;
                this.getStomach().lockHunger(hungerSuppression > 0.0f, hungerSuppression);
            } else if (--this.hungerCooldown <= 0) {
                this.getStomach().unlockHunger();
            }
            this.properties.markDirty();
        }
        if (shouldLockHunger && this.getStomach().getLockedState() != null) {
            this.getStomach().getLockedState().setRate(hungerSuppression);
        }
        if (this.getGlut().getOvereating() >= 10.0f) {
            this.vomit();
        }
        if (this.vomitingTicks > 0) {
            --this.vomitingTicks;
            if (this.entity.field_6012 % (int)(1.0f + this.entity.method_37908().field_9229.method_43057() * 3.0f) == 0) {
                int count = (int)(this.entity.method_37908().field_9229.method_43057() * (float)(this.vomitingTicks / 2));
                for (int i = 0; i < count; ++i) {
                    --this.vomitingTicks;
                    if (this.entity.method_37908().field_9236) continue;
                    this.entity.method_7329(PSItems.VOMIT.method_7854(), true, true).method_6989();
                    this.playBarfNoise();
                }
                this.properties.markDirty();
            }
        }
        if (this.vomitCooldown > 0) {
            this.properties.markDirty();
            if (this.vomitCooldown-- <= 0) {
                this.vomitCount = 0;
            }
        }
    }

    public void vomit() {
        class_1799 heldItem = this.entity.method_5998(class_1268.field_5810);
        if (heldItem.method_31574(PSItems.PAPER_BAG) && BagContentsComponent.get(heldItem).isEmpty()) {
            this.playBarfNoise();
            if (!this.entity.method_7337()) {
                heldItem.method_7934(1);
            }
            if (heldItem.method_7960()) {
                this.entity.method_6122(class_1268.field_5810, PSItems.BAG_O_VOMIT.method_7854());
            } else {
                this.entity.method_31548().method_7398(PSItems.BAG_O_VOMIT.method_7854());
            }
        } else {
            class_1937 class_19372 = this.entity.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 sw = (class_3218)class_19372;
                this.vomitingTicks = sw.field_9229.method_39332(10, 100);
                if (++this.vomitCount > 16) {
                    this.entity.method_64397(sw, this.properties.damageOf(PSDamageTypes.OVER_EATING), 2.1474836E9f);
                }
            }
        }
        this.entity.method_6092(new class_1293(class_1294.field_5916, 100, 1));
        this.getGlut().setOvereating(0.0f);
        this.properties.markDirty();
    }

    private void playBarfNoise() {
        this.entity.method_37908().method_43129(null, (class_1297)this.entity, class_3417.field_15225, this.entity.method_5634(), 1.0f, (float)this.entity.method_37908().field_9229.method_43385(0.5, 0.25));
    }

    @Override
    public void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        if (compound.method_10573("hunger", 10)) {
            this.getStomach().setLockedState(LockableHungerManager.State.fromNbt(compound.method_10562("hunger")));
        } else {
            this.getStomach().unlockHunger();
        }
        this.vomitCount = compound.method_10550("vomitCount");
        this.vomitCooldown = compound.method_10550("vomitCooldown");
        this.vomitingTicks = compound.method_10550("vomitingTicks");
        this.hungerCooldown = compound.method_10550("hungerCooldown");
    }

    @Override
    public void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        LockableHungerManager.State lockedHungerState = this.getStomach().getLockedState();
        if (lockedHungerState != null) {
            compound.method_10566("hunger", (class_2520)lockedHungerState.toNbt());
        }
        compound.method_10569("vomitCount", this.vomitCount);
        compound.method_10569("vomitCooldown", this.vomitCooldown);
        compound.method_10569("vomitingTicks", this.vomitingTicks);
        compound.method_10569("hungerCooldown", this.hungerCooldown);
    }
}

