/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.hallucination;

import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.entity.drug.Attribute;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.hallucination.AttributeFunction;
import ivorius.psychedelicraft.entity.drug.hallucination.DriftingCamera;
import ivorius.psychedelicraft.entity.drug.hallucination.EntityHallucinationList;
import ivorius.psychedelicraft.entity.drug.hallucination.MindColor;
import ivorius.psychedelicraft.entity.drug.hallucination.Visualisations;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class HallucinationManager {
    private final DrugProperties properties;
    private final Visualisations visualisations = new Visualisations();
    private final EntityHallucinationList entities = new EntityHallucinationList(this);
    private final DriftingCamera camera = new DriftingCamera();
    private final MindColor surfaceColor = new MindColor(this);
    private final MindColor bloomColor = new MindColor(this);
    private final MindColor pulseColor = new MindColor(this);
    private final MindColor skyColor = new MindColor(this);
    private final List<class_2248> fractalTypes = List.of(class_2246.field_10316, class_2246.field_27159, class_2246.field_10104, class_2246.field_10117);
    private int fractalType = 0;

    public HallucinationManager(DrugProperties properties) {
        this.properties = properties;
    }

    public void update() {
        this.entities.update();
        this.camera.update(this.properties);
        this.visualisations.update(this.properties);
        this.surfaceColor.update();
        this.bloomColor.update();
        this.pulseColor.update();
        if (this.get(Drug.FRACTALS) > 0.0f) {
            class_5819 random = this.properties.asEntity().method_37908().field_9229;
            if (random.method_43048(20) == 0) {
                this.fractalType = random.method_43048(this.fractalTypes.size());
            }
        } else {
            this.fractalType = 0;
        }
    }

    public DrugProperties getProperties() {
        return this.properties;
    }

    public EntityHallucinationList getEntities() {
        return this.entities;
    }

    public Visualisations getVisualisations() {
        return this.visualisations;
    }

    public DriftingCamera getCamera() {
        return this.camera;
    }

    public float get(Attribute attribute) {
        return AttributeFunction.FUNCTIONS.get(attribute, this);
    }

    public float getEntityHallucinationStrength() {
        return this.visualisations.getMultiplier(0) * 0.4f;
    }

    public class_2680 getFractalAppearance() {
        return this.fractalTypes.get(this.fractalType).method_9564();
    }

    public Vector4f getPulseColor(float tickDelta, boolean sky) {
        if (sky) {
            return MathUtils.TEMP_VECTOR.set((Vector3fc)this.pulseColor.getColor(tickDelta), ShaderContext.modifier(Drug.RAINBOW_WAVES));
        }
        float alpha = class_3532.method_15363((float)this.visualisations.getMultiplier(8), (float)0.0f, (float)1.0f);
        if (alpha == 0.0f) {
            return MathUtils.ZERO;
        }
        return MathUtils.TEMP_VECTOR.set((Vector3fc)this.pulseColor.getColor(tickDelta), alpha);
    }

    public Vector4fc getColorBloom(float tickDelta, boolean sky) {
        return MathUtils.mixColorsDynamic((Vector3fc)(sky ? this.skyColor : this.bloomColor).getColor(tickDelta), Drug.BLOOM.apply(this.properties), class_3532.method_15363((float)(1.5f * this.visualisations.getMultiplier(102)), (float)0.0f, (float)1.5f));
    }

    public Vector4fc getContrastColorization(float tickDelta) {
        return MathUtils.mixColorsDynamic((Vector3fc)this.surfaceColor.getColor(tickDelta), Drug.CONTRAST_COLORIZATION.apply(this.properties), class_3532.method_15363((float)this.visualisations.getMultiplier(103), (float)0.0f, (float)0.8f));
    }

    public float[] getBlur() {
        float menuBlur = Math.max(0.0f, this.properties.getDrugValue(DrugType.SLEEP_DEPRIVATION) - 0.7f) * ShaderContext.tickDelta() * 15.0f;
        float vBlur = ShaderContext.drug(DrugType.POWER) + menuBlur;
        float hBlur = menuBlur + (ShaderContext.drug(DrugType.BATH_SALTS) * 6.0f + ShaderContext.drug(DrugType.BATH_SALTS) * (ShaderContext.ticks() % 5.0f));
        return new float[]{hBlur, vBlur};
    }
}

