/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug.type;

import ivorius.psychedelicraft.entity.drug.DrugAttributeFunctions;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.type.SimpleDrug;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class MorphineDrug
extends SimpleDrug {
    public static final DrugAttributeFunctions MORPHINE_FUNCTIONS = DrugAttributeFunctions.builder().put(HEART_BEAT_VOLUME, (f, t) -> MathUtils.project(f, 0.4f, 1.0f)).put(HEART_BEAT_SPEED, (f, t) -> -f * 0.8f).put(HAND_TREMBLE_STRENGTH, 0.001f).put(VIEW_TREMBLE_STRENGTH, 0.002f).put(PAIN_SUPPRESSION, f -> 1.0f - f * 0.6f).build();
    public static final DrugAttributeFunctions METH_FUNCTIONS = DrugAttributeFunctions.builder().put(HEART_BEAT_VOLUME, (f, t) -> -MathUtils.project(f, 0.4f, 1.0f) + (float)t * 1.0E-4f * 1.2f).put(HEART_BEAT_SPEED, (f, t) -> -f * 0.1f - (float)t * 1.0E-4f).put(HAND_TREMBLE_STRENGTH, 0.1f).put(VIEW_TREMBLE_STRENGTH, 0.2f).put(PAIN_SUPPRESSION, f -> 1.0f - f * 0.9f).build();

    public MorphineDrug(DrugType<MorphineDrug> type, double decSpeed, double decSpeedPlus) {
        super(type, decSpeed, decSpeedPlus);
    }

    @Override
    protected boolean tickSideEffects(class_3218 world, DrugProperties properties, class_5819 random) {
        class_1657 entity = properties.asEntity();
        double chance = (this.getActiveValue() - (double)0.8f) * (double)0.051f;
        if (this.getType() == DrugType.METHAMPHETAMINE) {
            if (entity.field_6012 % 20 == 0 && (double)random.method_43057() < chance) {
                if (random.method_43057() < 0.8f && properties.rollStroke()) {
                    return true;
                }
                if (random.method_43057() < 0.5f) {
                    properties.increaseCardiacArrestSideEffect();
                    return true;
                }
            }
            if (this.getTicksActive() > 90) {
                properties.increaseTeethGrindingSideEffect();
            }
        }
        if (this.getTicksActive() < 10) {
            entity.field_6008 = 100;
        }
        if (properties.getModifier(HEART_BEAT_SPEED) < 0.3f && properties.getModifier(HEART_BEAT_VOLUME) > 0.8f) {
            if (random.method_43057() < 0.08f && properties.rollStroke()) {
                return true;
            }
            if (random.method_43057() < 0.05f) {
                properties.increaseCardiacArrestSideEffect();
                return true;
            }
        }
        return super.tickSideEffects(world, properties, random);
    }
}

