/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import ivorius.psychedelicraft.PSTags;
import ivorius.psychedelicraft.block.entity.FluidProcessingBlockEntity;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.fluid.DrugFluid;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.Processable;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.alcohol.AlcoholicFluidState;
import ivorius.psychedelicraft.fluid.alcohol.DrinkType;
import ivorius.psychedelicraft.fluid.alcohol.DrinkTypes;
import ivorius.psychedelicraft.fluid.alcohol.Maturity;
import ivorius.psychedelicraft.fluid.alcohol.TickRate;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.fluid.physical.FluidStateManager;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2688;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_9285;
import org.jetbrains.annotations.Nullable;

public class AlcoholicFluid
extends DrugFluid
implements Processable,
TickRate.Tickable {
    public static final SimpleFluid.Attribute<Integer> DISTILLATION = SimpleFluid.Attribute.ofInt("distillation", 0, 16);
    public static final SimpleFluid.Attribute<Integer> MATURATION = SimpleFluid.Attribute.ofInt("maturation", 0, 16);
    private static final int FERMENTATION_STEPS = 2;
    public static final SimpleFluid.Attribute<Integer> FERMENTATION = SimpleFluid.Attribute.ofInt("fermentation", 0, 2);
    public static final SimpleFluid.Attribute<Boolean> VINEGAR = SimpleFluid.Attribute.ofBoolean("vinegar");
    final Settings settings;

    public AlcoholicFluid(class_2960 id, Settings settings) {
        super(id, (DrugFluid.Settings)settings.drinkable().with(new FluidStateManager.FluidProperty<Integer>((class_2769<Integer>)class_2758.method_11867((String)"variant", (int)0, (int)settings.variants.variants().size()), (BiConsumer<Map<String, Integer>, Integer>)((BiConsumer<Map, Integer>)(properties, value) -> settings.variants.findState((int)value).apply((Map<String, Integer>)properties)), stack -> settings.variants.findId((ItemFluids)stack))));
        this.settings = settings;
    }

    @Override
    public boolean hasRandomTicks() {
        return true;
    }

    protected int getDistilledColor() {
        return this.settings.distilledColor;
    }

    protected int getMatureColor() {
        return this.settings.matureColor;
    }

    @Override
    public void getDrugInfluencesPerLiter(ItemFluids stack, Consumer<DrugInfluence> consumer) {
        super.getDrugInfluencesPerLiter(stack, consumer);
        double alcohol = this.getAlcoholContent(stack);
        if (alcohol > 0.0) {
            consumer.accept(new DrugInfluence(this.settings.drugType, 20, 0.003, 0.002, alcohol));
        }
        this.settings.variants.find(stack).extraDrug().ifPresent(consumer);
    }

    double getAlcoholContent(ItemFluids stack) {
        if (this.settings.variants.find(stack).isOf(DrinkType.VINEGAR)) {
            return 0.0;
        }
        return this.settings.fermentationAlcohol * ((double)FERMENTATION.get(stack).intValue() / 2.0) + this.settings.distillationAlcohol * (double)MathUtils.progress(DISTILLATION.get(stack).intValue()) + this.settings.maturationAlcohol * (double)MathUtils.progress((float)MATURATION.get(stack).intValue() * 0.2f);
    }

    @Override
    public void onRandomTick(class_3218 world, class_2338 pos, class_3610 state, class_5819 random) {
        if (this.getAlcoholContent(this.getStack((class_2688<?, ?>)state, 1)) > 0.3) {
            world.method_8335(null, class_238.method_30048((class_243)pos.method_46558(), (double)5.0, (double)5.0, (double)5.0)).forEach(entity -> {
                if (random.method_43048(450) == 0) {
                    DrugProperties.of(entity).ifPresent(properties -> properties.addToDrug(DrugType.ALCOHOL, 0.1));
                }
            });
        }
    }

    @Override
    public Processable.ProcessType modifyProcess(Resovoir tank, Processable.ProcessType type) {
        if (type == Processable.ProcessType.FERMENT && FERMENTATION.get(tank.getContents()) >= 2) {
            return Processable.ProcessType.ACETIFY;
        }
        return type;
    }

    @Override
    public int getProcessingTime(Resovoir tank, Processable.ProcessType type) {
        return switch (type) {
            case Processable.ProcessType.FERMENT -> this.getTickRate().ticksPerFermentation();
            case Processable.ProcessType.DISTILL -> {
                if (FERMENTATION.get(tank.getContents()) == 0 || MATURATION.get(tank.getContents()) != 0) {
                    yield -1;
                }
                yield this.getTickRate().ticksPerDistillation();
            }
            case Processable.ProcessType.MATURE -> {
                if (FERMENTATION.get(tank.getContents()) == 0) {
                    yield -1;
                }
                yield this.getTickRate().ticksPerMaturation();
            }
            case Processable.ProcessType.ACETIFY -> {
                if (VINEGAR.get(tank.getContents()).booleanValue()) {
                    yield -1;
                }
                yield this.getTickRate().ticksUntilAcetification();
            }
            case Processable.ProcessType.PURIFY -> 1;
            default -> -1;
        };
    }

    @Override
    public void process(Processable.Context context, Processable.ProcessType type, Processable.ByProductConsumer output) {
        Resovoir tank = context.getPrimaryTank();
        switch (type) {
            case DISTILL: {
                int amountDrained = class_3532.method_15375((float)((float)tank.getContents().amount() * MathUtils.progress(DISTILLATION.get(tank.getContents()).intValue(), 0.5f)));
                if (amountDrained > 0) {
                    tank.drain(1);
                    output.accept(PSFluids.SLURRY.getDefaultStack());
                }
                tank.setContents(DISTILLATION.cycle(tank.getContents()));
                break;
            }
            case MATURE: {
                tank.setContents(MATURATION.cycle(tank.getContents()));
                break;
            }
            case FERMENT: {
                tank.setContents(FERMENTATION.cycle(tank.getContents()));
                break;
            }
            case ACETIFY: {
                tank.setContents(VINEGAR.set(tank.getContents(), (Boolean)true));
                break;
            }
            case PURIFY: {
                double alcohol = this.getAlcoholContent(tank.getContents()) / 10.0;
                int consumed = Math.max(1, tank.getContents().amount() / 10);
                tank.drain(consumed * 2);
                output.accept(alcohol == 0.0 ? SimpleFluid.of((class_3611)class_3612.field_15910).getDefaultStack(consumed) : PSFluids.ETHANOL.getDefaultStack((int)Math.ceil(alcohol) * consumed));
                break;
            }
        }
    }

    @Override
    public Stream<Processable.Process> getProcesses() {
        return this.settings.variants.variants().stream().flatMap(variant -> {
            AlcoholicFluidState state = variant.predicate().state();
            String key = "_" + variant.value().getUniqueKey();
            return Stream.of(new Processable.Process(this, this.getId().method_48331(key + "_alco"), this.getAlcoTransitions(state)), new Processable.Process(this, this.getId().method_48331(key + "_chem"), this.getChemTransitions(state)));
        });
    }

    private List<Processable.Transition> getAlcoTransitions(AlcoholicFluidState state) {
        int fermentations = state.fermentation();
        int distillations = state.distillation();
        int maturations = state.maturation();
        Function<ItemFluids, ItemFluids> withFerment = i -> FERMENTATION.set((ItemFluids)i, (Integer)fermentations);
        Function<ItemFluids, ItemFluids> withDistil = withFerment.andThen(i -> DISTILLATION.set((ItemFluids)i, (Integer)distillations));
        Function<ItemFluids, ItemFluids> withMature = withDistil.andThen(i -> MATURATION.set((ItemFluids)i, (Integer)maturations));
        ArrayList<Processable.Transition> result = new ArrayList<Processable.Transition>();
        if (fermentations > 0) {
            result.add(new Processable.Transition(Processable.ProcessType.FERMENT, this.getTickRate().ticksPerFermentation(), fermentations, Function.identity(), withFerment));
        }
        if (state.vinegar()) {
            result.add(new Processable.Transition(Processable.ProcessType.ACETIFY, this.getTickRate().ticksPerFermentation(), 3, withMature, state::apply));
        }
        if (distillations > 0) {
            result.add(new Processable.Transition(Processable.ProcessType.DISTILL, this.getTickRate().ticksPerDistillation(), distillations, withFerment, withDistil));
        }
        if (maturations > 0) {
            result.add(new Processable.Transition(Processable.ProcessType.MATURE, this.getTickRate().ticksPerMaturation(), maturations, withDistil, withMature));
        }
        return result;
    }

    @Override
    public TickRate getDefaultTickRate() {
        return this.settings.defaultTickInfo;
    }

    private List<Processable.Transition> getChemTransitions(AlcoholicFluidState state) {
        return List.of(new Processable.Transition(Processable.ProcessType.PURIFY, 0, 1, state::apply, to -> {
            double alcohol = this.getAlcoholContent(state.apply((ItemFluids)to)) / 10.0;
            return alcohol == 0.0 ? SimpleFluid.of((class_3611)class_3612.field_15910).getDefaultStack(1) : PSFluids.ETHANOL.getDefaultStack((int)Math.ceil(alcohol));
        }));
    }

    @Override
    public int getHash(ItemFluids stack) {
        return Objects.hash(this, this.getVariant(stack));
    }

    @Override
    public class_2561 getName(ItemFluids stack) {
        return this.getVariant(stack).getName((class_2561)class_2561.method_43471((String)this.getTranslationKey()));
    }

    @Override
    public String getUniqueKey(ItemFluids stack) {
        return "_" + this.getVariant(stack).getUniqueKey();
    }

    public DrinkType getVariant(ItemFluids stack) {
        return this.settings.variants.find(stack);
    }

    @Override
    public void appendTooltip(ItemFluids stack, Consumer<class_2561> tooltip, class_1836 type) {
        int distillation = DISTILLATION.get(stack);
        int maturation = MATURATION.get(stack);
        int fermentation = FERMENTATION.get(stack);
        if (distillation > 0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.alcohol.distillations", (Object[])new Object[]{distillation}).method_27692(class_124.field_1080));
        }
        if (fermentation > 0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.alcohol.fermentations", (Object[])new Object[]{fermentation}).method_27692(class_124.field_1080));
        }
        if (maturation > 0) {
            tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.alcohol.maturations", (Object[])new Object[]{maturation, Maturity.getMaturity(maturation).getName()}).method_27692(class_124.field_1080));
        }
        tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.alcohol.potency", (Object[])new Object[]{class_9285.field_49329.format(this.getAlcoholContent(stack))}).method_27692(class_124.field_1080));
    }

    @Override
    public void appendTankTooltip(ItemFluids stack, @Nullable class_1937 world, List<class_2561> tooltip, FluidProcessingBlockEntity tank) {
        super.appendTankTooltip(stack, world, tooltip, tank);
        if (tank.getProcessType() == Processable.ProcessType.DISTILL) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Requirements:"));
            if (FERMENTATION.get(stack) == 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Must be fermented").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Is fermented").method_27692(class_124.field_1080));
            }
            if (MATURATION.get(stack) > 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Must be unmatured").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Is unmatured").method_27692(class_124.field_1080));
            }
        } else if (tank.getProcessType() == Processable.ProcessType.MATURE) {
            if (FERMENTATION.get(stack) == 0) {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Must be fermented").method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"* Is fermented").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}));
            }
        }
    }

    @Override
    public int getColor(ItemFluids stack) {
        return MathUtils.mixColors(MathUtils.mixColors(super.getColor(stack), this.getDistilledColor(), MathUtils.progress(DISTILLATION.get(stack).intValue())), this.getMatureColor(), MathUtils.progress((float)MATURATION.get(stack).intValue() * 0.2f));
    }

    @Override
    public class_2960 getSymbol(ItemFluids stack) {
        return this.settings.variants.find(stack).getSymbol(this.getId());
    }

    @Override
    public Stream<ItemFluids> getDefaultStacks(int capacity) {
        return this.settings.variants.variants().stream().map(variant -> variant.predicate().state().apply(this.getDefaultStack(capacity)));
    }

    public List<DrinkTypes.Variant> getVariants() {
        return this.settings.variants.variants();
    }

    @Override
    public boolean isSuitableContainer(class_1799 container) {
        return (container.method_31573(this.getPreferredContainerTag()) || container.method_31574(class_1802.field_8550) || container.method_31574((class_1792)PSItems.FILLED_BUCKET)) && !container.method_31574((class_1792)PSItems.SHOT_GLASS);
    }

    @Override
    public class_6862<class_1792> getPreferredContainerTag() {
        return PSTags.Items.SUITABLE_ALCOHOLIC_DRINK_RECEPTICALS;
    }

    public static class Settings
    extends DrugFluid.Settings {
        protected DrinkTypes variants = DrinkTypes.empty();
        private double fermentationAlcohol;
        private double distillationAlcohol;
        private double maturationAlcohol;
        private int matureColor = -866573032;
        private int distilledColor = 0x33FFFFFF;
        DrugType<?> drugType = DrugType.ALCOHOL;
        private TickRate defaultTickInfo = TickRate.DEFAULT;

        public Settings() {
            this.appearance = stack -> this.variants.find((ItemFluids)stack).appearance();
        }

        public Settings drug(DrugType<?> drug) {
            this.drugType = drug;
            return this;
        }

        public Settings matureColor(int matureColor) {
            this.matureColor = matureColor;
            return this;
        }

        public Settings distilledColor(int distilledColor) {
            this.distilledColor = distilledColor;
            return this;
        }

        public Settings variants(DrinkTypes variants) {
            this.variants = variants;
            return this;
        }

        public Settings alcohol(double fermentationAlcohol, double distillationAlcohol, double maturationAlcohol) {
            this.fermentationAlcohol = fermentationAlcohol;
            this.distillationAlcohol = distillationAlcohol;
            this.maturationAlcohol = maturationAlcohol;
            return this;
        }

        public Settings tickRate(TickRate defaultTickInfo) {
            this.defaultTickInfo = defaultTickInfo;
            return this;
        }
    }
}

