/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.fluid;

import com.mojang.serialization.Codec;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface Processable {
    public static final int UNCONVERTABLE = -1;

    public int getProcessingTime(Resovoir var1, ProcessType var2);

    public void process(Context var1, ProcessType var2, ByProductConsumer var3);

    public Stream<Process> getProcesses();

    default public ProcessType modifyProcess(Resovoir tank, ProcessType type) {
        return type;
    }

    public static enum ProcessType implements class_3542
    {
        IDLE,
        DISTILL,
        MATURE,
        FERMENT,
        ACETIFY,
        COOL,
        PURIFY,
        SEPARATE;

        private final String name = this.name().toLowerCase(Locale.ROOT);
        private final class_2561 status = class_2561.method_43471((String)("fluid.status." + this.name));
        private final String timeLabel = "time.until." + this.name;
        public static final Codec<ProcessType> CODEC;
        public static final class_9139<class_9129, ProcessType> PACKET_CODEC;

        public class_2561 getStatus() {
            return this.status;
        }

        public String getTimeLabelTranslationKey() {
            return this.timeLabel;
        }

        public String method_15434() {
            return this.name;
        }

        public static void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
            ProcessType processType = (ProcessType)((Object)stack.method_57824(PSComponents.PROCESS_TYPE));
            if (processType != null) {
                tooltip.add((class_2561)class_2561.method_43471((String)("psychedelicraft.container.process_type." + processType.method_15434())).method_27692(class_124.field_1078));
            }
        }

        static {
            CODEC = class_3542.method_53955(ProcessType::values);
            PACKET_CODEC = PacketCodecUtils.ofEnum(ProcessType.class);
        }
    }

    public static interface Context
    extends class_1263 {
        default public Resovoir getTankOnSide(class_2350 direction) {
            return this.getPrimaryTank();
        }

        default public List<Resovoir> getAuxiliaryTanks() {
            return List.of(this.getPrimaryTank());
        }

        default public int getTotalFluidVolume() {
            return this.getAuxiliaryTanks().stream().mapToInt(r -> r.getContents().amount()).sum();
        }

        public Resovoir getPrimaryTank();
    }

    public static interface ByProductConsumer {
        public void accept(class_1799 var1);

        public void accept(ItemFluids var1);
    }

    public record Transition(ProcessType type, int time, int multiplier, Function<ItemFluids, ItemFluids> input, Function<ItemFluids, ItemFluids> output) {
    }

    public record Process(SimpleFluid fluid, class_2960 id, List<Transition> transitions) {
    }
}

