/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.PSDamageTypes;
import ivorius.psychedelicraft.PSSounds;
import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.influence.DrugInfluence;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.PSComponents;
import ivorius.psychedelicraft.util.CodecUtils;
import ivorius.psychedelicraft.util.RaytraceUtil;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_4094;
import net.minecraft.class_4151;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;

public record ItemDrugs(List<DrugInfluence> influences, OptionalInt smokeColor) implements class_9299
{
    public static final ItemDrugs EMPTY = new ItemDrugs(List.of(), OptionalInt.empty());
    public static final Codec<ItemDrugs> CODEC = RecordCodecBuilder.create(i -> i.group((App)DrugInfluence.CODEC.listOf().fieldOf("influences").forGetter(ItemDrugs::influences), (App)CodecUtils.optionalIntFieldOf(DrugInfluence.COLOR_CODEC, "smoke_color").forGetter(ItemDrugs::smokeColor)).apply((Applicative)i, ItemDrugs::of));
    public static final class_9139<class_9129, ItemDrugs> PACKET_CODEC = class_9139.method_56435((class_9139)DrugInfluence.PACKET_CODEC.method_56433(class_9135.method_56363()), ItemDrugs::influences, (class_9139)class_9135.field_54890, ItemDrugs::smokeColor, ItemDrugs::of);

    public ItemDrugs {
        influences = List.copyOf(influences);
    }

    public static ItemDrugs of(List<DrugInfluence> influences) {
        return ItemDrugs.of(influences, OptionalInt.empty());
    }

    public static ItemDrugs of(List<DrugInfluence> influences, OptionalInt smokeColor) {
        return new ItemDrugs(influences, smokeColor);
    }

    public static ItemDrugs of(DrugInfluence ... influences) {
        return ItemDrugs.of(List.of(influences));
    }

    public ItemDrugs withSmoke(int smokeColor) {
        return new ItemDrugs(this.influences, OptionalInt.of(smokeColor));
    }

    public static ItemDrugs get(class_1799 stack) {
        return (ItemDrugs)stack.method_57825(PSComponents.DRUGS, (Object)EMPTY);
    }

    public void applyTo(class_1799 stack, DrugProperties properties) {
        Impurities impurities = Impurities.get(stack);
        properties.addAll(impurities.modifyEffects(this.influences));
        if (impurities.impurities().contains((Object)Impurities.Impurity.SILICA)) {
            class_1937 class_19372 = properties.asEntity().method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 sw = (class_3218)class_19372;
                properties.asEntity().method_64397(sw, properties.damageOf(PSDamageTypes.GLASS_SHARD), 1.5f);
            }
            properties.asEntity().method_56078(PSSounds.ITEM_BROKEN_GLASS_EAT);
        }
        this.smokeColor.ifPresent(smokeColor -> {
            properties.startBreathingSmoke(10 + properties.asEntity().method_37908().field_9229.method_43048(10), smokeColor);
            properties.rollCancerDance();
            class_3966 hit = RaytraceUtil.raycastEntities((class_1297)properties.asEntity(), 3.0);
            if (hit != null) {
                PSCriteria.BREATHE_SMOKE_ON_ENTITY.trigger(properties.asEntity(), hit.method_17782());
                DrugProperties.of(hit.method_17782()).ifPresent(target -> {
                    target.addAll(this.influences.stream().map(i -> i.copyWithTarget(i.target() * (double)0.1f)).toList());
                    if (target.asEntity().method_37908().field_9229.method_43048(10) == 0 && target.rollCancerDance()) {
                        PSCriteria.CANCER.trigger(target.asEntity(), (class_1297)properties.asEntity());
                    }
                });
                class_1297 patt0$temp = hit.method_17782();
                if (patt0$temp instanceof class_1309) {
                    class_1309 l = (class_1309)patt0$temp;
                    if (l instanceof class_1308) {
                        class_1308 mob = (class_1308)l;
                        mob.method_5966();
                    }
                    if (l instanceof class_3988) {
                        class_3988 villager = (class_3988)l;
                        villager.method_20507(100);
                    } else {
                        class_1937 patt1$temp = properties.asEntity().method_37908();
                        if (patt1$temp instanceof class_3218) {
                            class_3218 sw = (class_3218)patt1$temp;
                            hit.method_17782().method_64397(sw, properties.asEntity().method_48923().method_48802(properties.asEntity()), 0.1f);
                        }
                    }
                    if (l instanceof class_4094) {
                        class_4094 observer = (class_4094)l;
                        observer.method_18870(class_4151.field_18476, (class_1297)properties.asEntity());
                    }
                }
            }
        });
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (type.method_8035() && !this.influences.isEmpty()) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"psychedelicraft.item.contained_drug_effects").method_27692(class_124.field_1080));
            this.influences.forEach(influence -> tooltip.accept((class_2561)class_2561.method_43469((String)"psychedelicraft.item.contained_drug_effects.entry", (Object[])new Object[]{influence.drugType().id(), class_2561.method_43470((String)String.format(Math.abs(influence.target()) > (double)1.0E-5f ? "%.2f" : "%.0f", influence.target())), class_2561.method_43470((String)String.format(Math.abs(influence.base()) > (double)1.0E-5f ? "%.3f" : "%.0f", influence.base()))}).method_27692(class_124.field_1064)));
        }
    }
}

