/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import ivorius.psychedelicraft.entity.drug.GluttonyManager;
import ivorius.psychedelicraft.entity.drug.LockableHungerManager;
import net.minecraft.class_1702;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
abstract class MixinHungerManager
implements LockableHungerManager,
GluttonyManager {
    @Shadow
    private int field_7756;
    @Shadow
    private float field_7753;
    @Nullable
    private LockableHungerManager.State lockedState;
    private float overeating;
    private boolean shaking;

    MixinHungerManager() {
    }

    @Override
    public float getActualSaturationLevel() {
        return this.field_7753;
    }

    @Override
    public int getActualFoodLevel() {
        return this.field_7756;
    }

    @Override
    public void setShanksShaking(boolean shaking) {
        this.shaking = shaking;
    }

    @Inject(method={"add(IF)V"}, at={@At(value="HEAD")})
    private void onAdd(int food, float saturationModifier, CallbackInfo info) {
        if (this.lockedState != null && !this.lockedState.full() && this.field_7756 + food > 20) {
            this.overeating += (float)food / 8.0f;
        }
    }

    @ModifyReturnValue(method={"isNotFull()Z"}, at={@At(value="RETURN")})
    private boolean onIsNotFull(boolean notFull) {
        return this.lockedState != null ? !this.lockedState.full() : notFull;
    }

    @ModifyReturnValue(method={"getFoodLevel()I"}, at={@At(value="RETURN")})
    private int onGetFoodLevel(int foodLevel) {
        return this.lockedState != null ? (int)this.lockedState.hunger().toFloat(foodLevel) : foodLevel;
    }

    @ModifyReturnValue(method={"getSaturationLevel()F"}, at={@At(value="RETURN")})
    private float onGetSaturationLevel(float saturation) {
        return this.shaking ? -1.0f : (this.lockedState != null ? this.lockedState.saturation().toFloat(saturation) : saturation);
    }

    @Inject(method={"setFoodLevel(I)V", "setSaturationLevel(F)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetFoodOrSaturationLevel(CallbackInfo info) {
        if (this.lockedState != null) {
            info.cancel();
        }
    }

    @Override
    public float getOvereating() {
        return this.overeating;
    }

    @Override
    public void setOvereating(float overeating) {
        this.overeating = overeating;
    }

    @Override
    @Nullable
    public LockableHungerManager.State getLockedState() {
        return this.lockedState;
    }

    @Override
    public void setLockedState(LockableHungerManager.State state) {
        this.lockedState = state;
    }

    @Override
    public class_1702 getHungerManager() {
        return (class_1702)this;
    }
}

