/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.recipe.ImpuritiesPredicate;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import ivorius.psychedelicraft.util.PacketCodecUtils;
import java.util.List;
import net.minecraft.class_10295;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;

public record HardeningRecipe(String hardeningGroup, FluidIngredient coreFluid, List<FluidIngredient> solutions, ImpuritiesPredicate impurities, class_1799 result, class_6017 amount, int hardeningTime) implements class_1860<Input>
{
    public static final MapCodec<HardeningRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.fieldOf("group").forGetter(HardeningRecipe::hardeningGroup), (App)FluidIngredient.CODEC.fieldOf("core_fluid").forGetter(HardeningRecipe::coreFluid), (App)FluidIngredient.CODEC.listOf().fieldOf("solutions").forGetter(HardeningRecipe::solutions), (App)ImpuritiesPredicate.CODEC.optionalFieldOf("impurities", (Object)ImpuritiesPredicate.EMPTY).forGetter(HardeningRecipe::impurities), (App)class_1799.field_51397.fieldOf("result").forGetter(HardeningRecipe::result), (App)class_6017.field_33451.fieldOf("amount").forGetter(HardeningRecipe::amount), (App)Codec.INT.optionalFieldOf("hardening_time", (Object)20).forGetter(HardeningRecipe::hardeningTime)).apply((Applicative)i, HardeningRecipe::new));
    public static final class_9139<class_9129, HardeningRecipe> PACKET_CODEC = PacketCodecUtils.tuple(class_9135.field_48554, HardeningRecipe::hardeningGroup, FluidIngredient.PACKET_CODEC, HardeningRecipe::coreFluid, FluidIngredient.PACKET_CODEC.method_56433(class_9135.method_56363()), HardeningRecipe::solutions, ImpuritiesPredicate.PACKET_CODEC, HardeningRecipe::impurities, class_1799.field_49268, HardeningRecipe::result, PacketCodecUtils.INT_PROVIDER_VALUE_CODEC, HardeningRecipe::amount, class_9135.field_49675, HardeningRecipe::hardeningTime, HardeningRecipe::new);

    public class_1865<HardeningRecipe> method_8119() {
        return PSRecipes.HARDENING;
    }

    public class_3956<HardeningRecipe> method_17716() {
        return PSRecipes.TRAY;
    }

    public boolean matches(Input input, class_1937 world) {
        FluidMound fluids = FluidMound.of(input.impurities());
        return this.isCoreFluid(input.coreFluid()) && this.solutions.stream().allMatch(i -> fluids.removeMatch((FluidIngredient)i, -1) > 0) && this.impurities.test(input.cuts());
    }

    public boolean isCoreFluid(ItemFluids fluids) {
        return this.coreFluid.test(fluids);
    }

    public boolean isValidImpurity(ItemFluids fluids) {
        return this.solutions.stream().anyMatch(i -> i.test(fluids)) || fluids.isOf(PSFluids.PETROLIUM) || fluids.isOf(PSFluids.ETHANOL) || fluids.isOf(PSFluids.GASOLINE);
    }

    public String method_8112() {
        return this.hardeningGroup;
    }

    public class_1799 craft(Input input, class_7225.class_7874 lookup) {
        FluidMound fluids = FluidMound.of(input.impurities());
        fluids.split(fluid -> this.solutions.stream().anyMatch(i -> i.test((ItemFluids)fluid)));
        Impurities inputCuts = this.impurities.permitted(input.cuts());
        int count = this.amount().method_35008(input.random()) * (int)Math.pow(2.0, inputCuts.impurities().size());
        return Impurities.set(this.result.method_46651(count), inputCuts);
    }

    public boolean method_8118() {
        return true;
    }

    public List<class_10295> method_64664() {
        return List.of(new class_10301(List.of(), (class_10302)new class_10302.class_10307(this.result), (class_10302)new class_10302.class_10306(PSItems.TRAY)));
    }

    public class_9887 method_61671() {
        return class_9887.field_52597;
    }

    public class_10355 method_64668() {
        return class_314.field_1810;
    }

    public record Input(class_5819 random, ItemFluids coreFluid, FluidMound impurities, Impurities cuts) implements class_9695
    {
        public class_1799 method_59984(int slot) {
            return class_1799.field_8037;
        }

        public int method_59983() {
            return 0;
        }

        public boolean method_59987() {
            return this.coreFluid.isEmpty() && this.impurities.isEmpty();
        }
    }
}

