/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.util.NbtSerialisable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class ItemMound
implements NbtSerialisable {
    private final List<class_1792> indexes = new ArrayList<class_1792>();
    private final Map<class_1792, Entry> items = new HashMap<class_1792, Entry>();

    public ItemMound() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemMound(ItemMound original) {
        ItemMound itemMound = original;
        synchronized (itemMound) {
            this.indexes.addAll(original.indexes);
            original.items.entrySet().forEach(entry -> this.items.put((class_1792)entry.getKey(), new Entry((Entry)entry.getValue())));
        }
    }

    public ItemMound(class_2487 compound, class_7225.class_7874 lookup) {
        this.fromNbt(compound, lookup);
    }

    public synchronized void addStack(class_1799 stack) {
        Entry entry = this.items.computeIfAbsent(stack.method_7909(), x$0 -> new Entry((class_1792)x$0));
        entry.push(stack.method_57380(), stack.method_7947());
        if (!this.indexes.contains(stack.method_7909())) {
            this.indexes.add(stack.method_7909());
        }
    }

    public synchronized class_1799 removeStack(int index, int amount) {
        if (index >= 0 && index < this.indexes.size()) {
            class_1799[] stack = new class_1799[]{class_1799.field_8037};
            this.items.compute(this.indexes.get(index), (i, entry) -> entry == null ? null : entry.remove(amount, stack));
            return stack[0];
        }
        return class_1799.field_8037;
    }

    public synchronized boolean removeWhere(@Nullable Predicate<class_1799> predicate, int max) {
        Iterator<Map.Entry<class_1792, Entry>> iter = this.items.entrySet().iterator();
        while (iter.hasNext()) {
            Entry entry = iter.next().getValue();
            if (predicate != null && !predicate.test(entry.item.method_7854())) continue;
            int available = Math.min(max, entry.count);
            max -= available;
            if (entry.removeWhere(null, available) == null) {
                this.indexes.remove(entry.item);
                iter.remove();
            }
            if (max > 0) continue;
            return true;
        }
        return false;
    }

    public synchronized int countMatches(@Nullable Predicate<class_1799> predicate) {
        return this.items.values().stream().mapToInt(i -> i.countMatches(predicate)).sum();
    }

    public synchronized boolean isEmpty() {
        return this.items.isEmpty();
    }

    public synchronized int size() {
        return this.items.size();
    }

    public synchronized class_1799 getStack(int index) {
        class_1799[] stack = new class_1799[]{class_1799.field_8037};
        Entry entry = this.items.get(this.indexes.get(index));
        entry.popSingle(stack, false);
        stack[0].method_7939(entry.count);
        return stack[0];
    }

    public synchronized int getCount(class_1792 item) {
        Entry entry = this.items.get(item);
        return entry == null ? 0 : entry.count;
    }

    public synchronized class_2371<class_1799> convertToItemStacks() {
        class_2371 stacks = class_2371.method_37434((int)this.size());
        this.items.forEach((item, entry) -> entry.toItemStacks((class_2371<class_1799>)stacks));
        return stacks;
    }

    public synchronized void clear() {
        this.items.clear();
        this.indexes.clear();
    }

    @Override
    public synchronized void toNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.items.forEach((item, count) -> compound.method_10566(class_7923.field_41178.method_10221(item).toString(), (class_2520)count.toNbt()));
    }

    @Override
    public synchronized void fromNbt(class_2487 compound, class_7225.class_7874 lookup) {
        this.clear();
        compound.method_10541().forEach(key -> Optional.ofNullable(class_2960.method_12829((String)key)).map(arg_0 -> ((class_7922)class_7923.field_41178).method_63535(arg_0)).filter(Objects::nonNull).ifPresent(item -> {
            Entry entry = this.items.computeIfAbsent((class_1792)item, x$0 -> new Entry((class_1792)x$0));
            if (!this.indexes.contains(item)) {
                this.indexes.add((class_1792)item);
            }
            if (compound.method_10573(key, 10)) {
                this.items.computeIfAbsent((class_1792)item, x$0 -> new Entry((class_1792)x$0)).fromNbt(compound.method_10562(key));
            } else if (compound.method_10573(key, 3)) {
                entry.push(class_9326.field_49588, compound.method_10550(key));
            }
        }));
    }

    private final class Entry {
        private static final Codec<Map<class_9326, ComponentStack>> COMPONENTS_CODEC = ComponentStack.CODEC.listOf().xmap(list -> list.stream().collect(Collectors.toUnmodifiableMap(p -> p.changes, p -> p, (a, b) -> b)), map -> map.entrySet().stream().map(e -> (ComponentStack)e.getValue()).toList());
        private int count;
        private final class_1792 item;
        private final Map<class_9326, ComponentStack> components = new HashMap<class_9326, ComponentStack>();

        Entry(class_1792 item) {
            this.item = item;
        }

        Entry(Entry entry) {
            this.item = entry.item;
            this.count = entry.count;
            this.components.putAll(entry.components);
        }

        public void fromNbt(class_2487 nbt) {
            this.count = nbt.method_10550("count");
            this.components.clear();
            NbtSerialisable.get(nbt, "components", COMPONENTS_CODEC).ifPresent(this.components::putAll);
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("count", this.count);
            NbtSerialisable.put(nbt, "components", COMPONENTS_CODEC, this.components);
            return nbt;
        }

        public void toItemStacks(class_2371<class_1799> stacks) {
            int outputted = 0;
            for (ComponentStack entry : this.components.values()) {
                outputted += entry.count;
                class_1799 stack = entry.getStack(this.item);
                int maxCount = stack.method_7914();
                int stackCount = entry.count / maxCount;
                for (int i = 0; i < stackCount; ++i) {
                    stacks.add((Object)stack.method_46651(maxCount));
                }
                int last = entry.count % maxCount;
                if (last <= 0) continue;
                stacks.add((Object)stack.method_46651(maxCount));
            }
            while (outputted++ < this.count) {
                stacks.add((Object)this.item.method_7854());
            }
        }

        public int countMatches(@Nullable Predicate<class_1799> predicate) {
            if (predicate == null) {
                return this.count;
            }
            int testCount = 0;
            int matchCount = 0;
            for (ComponentStack entry : this.components.values()) {
                testCount += entry.count;
                if (!predicate.test(entry.getStack(this.item))) continue;
                matchCount += entry.count;
            }
            if (predicate.test(this.item.method_7854())) {
                matchCount += this.count - testCount;
            }
            return matchCount;
        }

        public Entry removeWhere(@Nullable Predicate<class_1799> predicate, int count) {
            int matchCount = 0;
            int testCount = 0;
            if (this.count == 0) {
                this.components.clear();
            } else {
                Iterator<Map.Entry<class_9326, ComponentStack>> iter = this.components.entrySet().iterator();
                while (iter.hasNext() && count > 0) {
                    ComponentStack entry = iter.next().getValue();
                    int subtracted = Math.min(count, entry.count);
                    testCount += subtracted;
                    if (predicate != null && !predicate.test(entry.getStack(this.item))) continue;
                    count -= subtracted;
                    matchCount += subtracted;
                    if (subtracted <= entry.count) {
                        iter.remove();
                        continue;
                    }
                    entry.count -= subtracted;
                }
                if (predicate == null || predicate.test(this.item.method_7854())) {
                    matchCount += this.count - testCount;
                }
                this.count = Math.max(0, this.count - matchCount);
            }
            return this.count <= 0 ? null : this;
        }

        public void push(class_9326 changes, int count) {
            this.count += count;
            if (!changes.method_57848()) {
                this.components.compute(changes, (i, c) -> {
                    if (c == null) {
                        return new ComponentStack((class_9326)i, count);
                    }
                    c.count += count;
                    return c;
                });
            }
        }

        public Entry remove(int amount, class_1799[] outStack) {
            if ((amount = Math.min(this.count, amount)) <= 0) {
                outStack[0] = class_1799.field_8037;
                return null;
            }
            if (amount == 1) {
                return this.popSingle(outStack, true);
            }
            ComponentStack entry = this.components.entrySet().stream().map(Map.Entry::getValue).sorted(Comparator.comparing(i -> -i.count)).findFirst().orElse(null);
            if (entry == null) {
                outStack[0] = this.item.method_7854();
            } else {
                amount = Math.min(amount, entry.count);
                this.count -= amount;
                if (this.count <= 0) {
                    ItemMound.this.items.remove(this.item);
                }
                outStack[0] = entry.getStack(this.item).method_7972();
                if (amount >= entry.count) {
                    this.components.remove(entry.changes);
                } else {
                    entry.count -= amount;
                }
            }
            return this.count <= 0 ? null : this;
        }

        public Entry popSingle(class_1799[] outStack, boolean remove) {
            Iterator<Map.Entry<class_9326, ComponentStack>> iter;
            if (remove) {
                this.count = Math.max(0, this.count);
            }
            if (!(iter = this.components.entrySet().iterator()).hasNext()) {
                outStack[0] = this.item.method_7854();
            } else {
                ComponentStack entry = iter.next().getValue();
                if (remove) {
                    if (entry.count <= 1) {
                        iter.remove();
                    } else {
                        --entry.count;
                    }
                }
                outStack[0] = entry.getStack(this.item).method_7972();
            }
            return this.count <= 0 ? null : this;
        }

        private static final class ComponentStack {
            private static final Codec<ComponentStack> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_9326.field_49589.fieldOf("changes").forGetter(s -> s.changes), (App)Codec.INT.fieldOf("count").forGetter(s -> s.count)).apply((Applicative)i, ComponentStack::new));
            public final class_9326 changes;
            public int count;
            private class_1799 cachedStack;

            ComponentStack(class_9326 changes, int count) {
                this.changes = changes;
                this.count = count;
            }

            public class_1799 getStack(class_1792 item) {
                if (this.cachedStack == null) {
                    this.cachedStack = item.method_7854();
                    if (!this.changes.method_57848()) {
                        this.cachedStack.method_57366(this.changes);
                    }
                }
                return this.cachedStack;
            }
        }
    }
}

