/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.FluidCapacity;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_10295;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class MixingRecipe
extends class_1867 {
    public static final MapCodec<MixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)ItemFluids.CODEC.fieldOf("result").forGetter(MixingRecipe::getOutputFluid), (App)class_1856.field_46095.fieldOf("receptical").forGetter(i -> i.receptical), (App)class_1856.field_46095.listOf(1, 9).fieldOf("ingredients").forGetter(i -> i.input)).apply((Applicative)instance, MixingRecipe::new));
    public static final class_9139<class_9129, MixingRecipe> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.field_48554, class_1867::method_8112, RecipeUtils.CRAFTING_RECIPE_CATEGORY_PACKET_CODEC, class_1867::method_45441, ItemFluids.PACKET_CODEC, MixingRecipe::getOutputFluid, (class_9139)class_1856.field_48355, recipe -> recipe.receptical, (class_9139)class_1856.field_48355.method_56433(class_9135.method_56363()), i -> i.input, MixingRecipe::new);
    private final class_1856 receptical;
    private final List<class_1856> input;
    private final ItemFluids output;

    public MixingRecipe(String group, class_7710 category, ItemFluids output, class_1856 receptical, List<class_1856> input) {
        super(group, category, class_1799.field_8037, Stream.concat(input.stream(), Stream.of(receptical)).toList());
        this.receptical = receptical;
        this.input = input;
        this.output = output;
    }

    public ItemFluids getOutputFluid() {
        return this.output;
    }

    public class_1865 method_8119() {
        return PSRecipes.FILL_RECEPTICAL;
    }

    public boolean method_17730(class_9694 inventory, class_1937 world) {
        return this.getOutputRecepticals(inventory).count() == 1L && inventory.method_59988().method_61538((class_1860)this, null);
    }

    private Stream<class_1799> getOutputRecepticals(class_9694 inventory) {
        return RecipeUtils.recepticals(inventory.method_59989().stream()).filter((Predicate<class_1799>)this.receptical).filter(receptical -> this.input.stream().noneMatch(i -> i.method_8093(receptical)) && ItemFluids.of(receptical).isOf((class_3611)class_3612.field_15910) && FluidCapacity.getPercentage(receptical) >= 1.0f);
    }

    public class_1799 method_17729(class_9694 inventory, class_7225.class_7874 registries) {
        return this.getOutputRecepticals(inventory).findFirst().map(receptical -> this.output.amount() <= 1 ? this.output.ofFilling(receptical.method_7972()) : ItemFluids.set(receptical.method_7972(), this.output.ofAmount(Math.min(this.output.amount(), FluidCapacity.get(receptical))))).orElse(class_1799.field_8037);
    }

    public List<class_10295> method_64664() {
        return List.of(new class_10301(Stream.concat(this.input.stream(), Stream.of(this.receptical)).map(class_1856::method_64673).toList(), (class_10302)new class_10302.class_10304(this.receptical.method_8105().map(i -> new class_10302.class_10307(ItemFluids.set(((class_1792)i.comp_349()).method_7854(), this.output))).toList()), (class_10302)new class_10302.class_10306(class_1802.field_8465)));
    }
}

