/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.fluid.PSFluids;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.RecipeUtils;
import ivorius.psychedelicraft.recipe.ingredient.PSIngredients;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidIngredient(Optional<SimpleFluid> fluid, Optional<Integer> level, Map<String, Integer> attributes) implements CustomIngredient,
Predicate<class_1799>
{
    public static final FluidIngredient EMPTY = new FluidIngredient(Optional.empty(), Optional.empty(), Map.of());
    public static final MapCodec<FluidIngredient> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SimpleFluid.CODEC.optionalFieldOf("fluid").forGetter(FluidIngredient::fluid), (App)Codec.INT.optionalFieldOf("level").forGetter(FluidIngredient::level), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).optionalFieldOf("attributes", Map.of()).forGetter(FluidIngredient::attributes)).apply((Applicative)instance, FluidIngredient::new));
    public static final Codec<FluidIngredient> CODEC = Codec.either((Codec)SimpleFluid.CODEC.xmap(fluid -> new FluidIngredient(Optional.of(fluid), Optional.empty(), Map.of()), i -> i.fluid().orElse(PSFluids.EMPTY)), (Codec)MAP_CODEC.codec()).xmap(RecipeUtils::iDontCareWhich, Either::right);
    public static final class_9139<class_9129, FluidIngredient> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56382(SimpleFluid.PACKET_CODEC), FluidIngredient::fluid, (class_9139)class_9135.method_56382((class_9139)class_9135.field_49675), FluidIngredient::level, (class_9139)class_9135.method_56377(HashMap::new, (class_9139)class_9135.field_48554, (class_9139)class_9135.field_49675), FluidIngredient::attributes, FluidIngredient::new);

    public FluidIngredient {
        fluid = fluid.filter(f -> !f.isEmpty());
    }

    @Override
    public boolean test(class_1799 stack) {
        return this.test(ItemFluids.of(stack));
    }

    @Override
    public boolean test(ItemFluids fluids) {
        boolean result = true;
        result &= this.fluid.isEmpty() || fluids.fluid() == this.fluid.get();
        result &= this.attributes.isEmpty() || this.attributes.equals(fluids.attributes());
        return result &= this.level.isEmpty() || fluids.amount() >= this.level.get();
    }

    public ItemFluids getAsItemFluid(int capacity) {
        return ItemFluids.create(this.fluid.orElse(PSFluids.EMPTY), this.level.orElse(capacity), this.attributes);
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty() && this.level.isEmpty() && this.attributes.isEmpty();
    }

    @Deprecated
    public Stream<class_6880<class_1792>> getMatchingItems() {
        return FluidIngredient.allRecepticals(this.fluid);
    }

    @Deprecated
    static Stream<class_6880<class_1792>> allRecepticals(Optional<SimpleFluid> fluid) {
        return Stream.of(new class_1792[]{class_1802.field_8705, class_1802.field_8103, class_1802.field_28354, class_1802.field_8666, class_1802.field_27876, class_1802.field_8108, class_1802.field_8714, class_1802.field_37533, class_1802.field_8478, class_1802.field_8187, class_1802.field_8550, class_1802.field_8469, class_1802.field_8574, class_1802.field_8469, PSItems.BOTTLE, PSItems.WOODEN_MUG, PSItems.GLASS_CHALICE, PSItems.STONE_CUP, PSItems.SYRINGE, PSItems.FILLED_BUCKET, PSItems.FILLED_BOWL, PSItems.FILLED_GLASS_BOTTLE}).map(class_1792::method_40131);
    }

    public class_1856 toVanilla() {
        return new CustomIngredientImpl(this, this){

            public boolean method_65798(class_6880<class_1792> registryEntry) {
                return registryEntry.method_40227() && registryEntry.comp_349() != class_1802.field_8162;
            }
        };
    }

    public boolean requiresTesting() {
        return true;
    }

    public CustomIngredientSerializer<?> getSerializer() {
        return PSIngredients.FLUID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Optional<SimpleFluid> fluid = Optional.empty();
        private Optional<Integer> level = Optional.empty();
        private final Map<String, Integer> attributes = new HashMap<String, Integer>();

        public Builder fluid(SimpleFluid fluid) {
            this.fluid = Optional.of(fluid);
            return this;
        }

        public Builder fluid(class_3611 fluid) {
            return this.fluid(SimpleFluid.of(fluid));
        }

        public Builder level(int level) {
            this.level = Optional.of(level);
            return this;
        }

        public Builder attribute(String attribute, int value) {
            this.attributes.put(attribute, value);
            return this;
        }

        public FluidIngredient build() {
            return new FluidIngredient(this.fluid, this.level, Map.copyOf(this.attributes));
        }
    }
}

