/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import ivorius.psychedelicraft.advancement.PSCriteria;
import ivorius.psychedelicraft.block.FluidMachineBlock;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.FluidFilled;
import ivorius.psychedelicraft.block.entity.MashTubBlockEntity;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.fluid.container.Resovoir;
import ivorius.psychedelicraft.item.MashTubItem;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.screen.FluidContraptionScreenHandler;
import ivorius.psychedelicraft.screen.PSScreenHandlers;
import ivorius.psychedelicraft.util.compat.EitherCompat;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3726;
import net.minecraft.class_3917;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5328;
import net.minecraft.class_5819;
import net.minecraft.class_6089;
import org.jetbrains.annotations.Nullable;

public class MashTubBlock
extends FluidMachineBlock<MashTubBlockEntity>
implements FluidFilled {
    public static final int SIZE = 15;
    public static final int BORDER_SIZE = 1;
    public static final int HEIGHT = 16;
    public static final class_2758 LIGHT = class_2741.field_12538;
    static final class_265 COLLISSION_SHAPE = class_259.method_17786((class_265)MashTubBlock.createShape(-8.0, 0.0, -8.0, 32.0, 16.0, 1.0), (class_265[])new class_265[]{MashTubBlock.createShape(-8.0, 0.0, 23.0, 32.0, 16.0, 1.0), MashTubBlock.createShape(23.0, 0.0, -8.0, 1.0, 16.0, 32.0), MashTubBlock.createShape(-8.0, 0.0, -8.0, 1.0, 16.0, 32.0), MashTubBlock.createShape(-8.0, 0.0, -8.0, 32.0, 1.0, 32.0)});
    static final class_265 RAYCAST_SHAPE = MashTubBlock.createShape(-8.0, 0.0, -8.0, 32.0, 16.0, 32.0);
    static final class_265 CORNER_RAYCAST_SHAPE = MashTubBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    static final class_265[] RAYCAST_SHAPES = new class_265[]{CORNER_RAYCAST_SHAPE.method_1096(0.5, 0.0, 0.5), MashTubBlock.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), CORNER_RAYCAST_SHAPE.method_1096(0.0, 0.0, 0.5), MashTubBlock.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), class_259.method_1077(), MashTubBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), CORNER_RAYCAST_SHAPE.method_1096(0.5, 0.0, 0.0), class_259.method_1077(), CORNER_RAYCAST_SHAPE};

    static class_265 getShape(int x, int z) {
        x = class_3532.method_15340((int)x, (int)0, (int)3);
        z = class_3532.method_15340((int)z, (int)0, (int)3);
        return (new class_265[]{CORNER_RAYCAST_SHAPE.method_1096(0.0, 0.0, 0.0), MashTubBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), CORNER_RAYCAST_SHAPE.method_1096(0.5, 0.0, 0.0), MashTubBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), class_259.method_1077(), MashTubBlock.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), CORNER_RAYCAST_SHAPE.method_1096(0.0, 0.0, 0.5), MashTubBlock.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), CORNER_RAYCAST_SHAPE.method_1096(0.5, 0.0, 0.5)})[x + z * 3];
    }

    private static class_265 createShape(double x, double y, double z, double width, double height, double depth) {
        return class_2248.method_9541((double)x, (double)y, (double)z, (double)(x + width), (double)(y + height), (double)(z + depth));
    }

    public MashTubBlock(class_4970.class_2251 settings) {
        super(settings.method_9631(class_6089.field_31189).method_9624());
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_9526(class_2680 state) {
        return true;
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 0.2f;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return COLLISSION_SHAPE;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return RAYCAST_SHAPE;
    }

    @Override
    protected class_2591<MashTubBlockEntity> getBlockEntityType() {
        return PSBlockEntities.MASH_TUB;
    }

    @Override
    protected class_3917<FluidContraptionScreenHandler<MashTubBlockEntity>> getScreenHandlerType() {
        return PSScreenHandlers.MASH_TUB;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        world.method_35230(this.getBlockEntityPosition((class_1922)world, pos), this.getBlockEntityType()).ifPresent(be -> {
            ItemFluids fluid = be.getPrimaryTank().getContents();
            fluid.fluid().randomDisplayTick(world, pos, fluid.fluid().getFluidState(fluid), random);
        });
    }

    @Override
    public class_1269 onInteract(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, MashTubBlockEntity blockEntity) {
        class_1799 heldStack = player.method_5998(hand);
        if (!heldStack.method_7960()) {
            return (class_1269)EitherCompat.unwrap(blockEntity.interactWithItem(heldStack, player).mapLeft(stack -> {
                if (!world.field_9236) {
                    player.method_6122(hand, class_5328.method_30012((class_1799)heldStack, (class_1657)player, (class_1799)stack));
                }
                return class_1269.field_5812;
            }));
        }
        if (!blockEntity.solidContents.method_7960()) {
            PSCriteria.SIMPLY_MASHING.trigger(player, blockEntity.solidContents);
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)blockEntity.solidContents);
            world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 1.0f, 1.0f);
            blockEntity.solidContents = class_1799.field_8037;
            blockEntity.markForUpdate();
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return MashTubItem.findPlacementPosition(world, pos).isPresent();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIGHT});
    }

    @Override
    public double getFluidHeight(class_1937 world, class_2680 state, class_2338 pos) {
        Double h = world.method_35230(pos, this.getBlockEntityType()).map(be -> be.getPrimaryTank()).map(tank -> (double)tank.getContents().amount() / (double)tank.getCapacity()).orElse(-1.0);
        return h < 0.0 ? -1.0 : class_3532.method_15350((double)((double)0.3f + h), (double)0.0, (double)1.0);
    }

    @Override
    public Optional<class_3610> getContainedFluid(class_1937 world, class_2680 state, class_2338 pos) {
        return world.method_35230(pos, this.getBlockEntityType()).map(be -> be.getPrimaryTank()).map(tank -> tank.getContents().fluid().getFluidState(tank.getContents()));
    }

    public boolean method_22358(class_2680 state, class_3611 fluid) {
        return false;
    }

    public boolean method_10310(@Nullable class_1657 player, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        if (player == null) {
            return false;
        }
        return world.method_35230(pos, this.getBlockEntityType()).filter(be -> {
            Resovoir tank = be.getPrimaryTank();
            return (tank.getContents().isEmpty() || tank.getContents().fluid().getPhysical().isOf(fluid)) && tank.getCapacity() - (long)tank.getContents().amount() >= 81000L;
        }).isPresent();
    }

    @Deprecated
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204()) && !world.field_9236) {
            class_2338.method_25996((class_2338)pos, (int)1, (int)0, (int)1).forEach(p -> {
                class_2680 neighbourState;
                if (!p.equals((Object)pos) && (neighbourState = world.method_8320(p)).method_27852(PSBlocks.MASH_TUB_EDGE)) {
                    world.method_8544(p);
                    world.method_8652(p, class_2246.field_10124.method_9564(), 3);
                }
            });
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        return world.method_35230(this.getBlockEntityPosition((class_1922)world, pos), this.getBlockEntityType()).filter(be -> {
            SimpleFluid f = SimpleFluid.of(fluidState.method_15772());
            if (be.getPrimaryTank().deposit(f.getStack((class_2688<?, ?>)fluidState, 81000)) > 0) {
                be.markForUpdate();
                return true;
            }
            return false;
        }).isPresent();
    }

    protected class_2338 getBlockEntityPosition(class_1922 world, class_2338 pos) {
        return world.method_35230(pos, PSBlockEntities.MASH_TUB_EDGE).map(p -> p.getMasterPos()).orElse(pos);
    }
}

