/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.FluidMound;
import ivorius.psychedelicraft.util.compat.EitherCompat;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;

public interface PipeInsertable {
    public static final Either<PipeFluids, class_3902> STATUS_VOIDED = Either.right((Object)class_3902.field_17274);
    public static final Either<PipeFluids, class_3902> STATUS_ACCEPT_ALL = Either.left((Object)PipeFluids.EMPTY);

    public static Either<PipeFluids, class_3902> reject(PipeFluids fluids) {
        return fluids.isEmpty() ? STATUS_ACCEPT_ALL : Either.left((Object)fluids);
    }

    default public boolean acceptsConnectionFrom(class_1936 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        return false;
    }

    default public Either<PipeFluids, class_3902> tryInsert(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction, PipeFluids fluids) {
        return STATUS_VOIDED;
    }

    default public Optional<PipeFluids> tryExtract(class_3218 world, class_2680 state, class_2338 pos, class_2350 direction) {
        return Optional.empty();
    }

    @Nullable
    public static PipeInsertable getPipeInterableAt(class_1936 world, class_2680 state, class_2338 pos) {
        PipeInsertable b;
        PipeInsertable a;
        class_2248 class_22482 = state.method_26204();
        return class_22482 instanceof PipeInsertable ? (a = (PipeInsertable)class_22482) : ((class_22482 = world.method_8321(pos)) instanceof PipeInsertable ? (b = (PipeInsertable)class_22482) : null);
    }

    public static boolean canConnectWith(class_1936 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        PipeInsertable pipe = PipeInsertable.getPipeInterableAt(world, neighborState, neighborPos);
        return pipe != null && pipe.acceptsConnectionFrom(world, neighborState, neighborPos, state, pos, direction.method_10153(), input);
    }

    public static Either<PipeFluids, class_3902> tryInsert(class_3218 world, class_2338 pos, class_2350 direction, PipeFluids fluids) {
        if (fluids.isEmpty()) {
            return STATUS_ACCEPT_ALL;
        }
        if (!world.method_22340(pos)) {
            return PipeInsertable.reject(fluids);
        }
        class_2680 state = world.method_8320(pos);
        PipeInsertable pipe = PipeInsertable.getPipeInterableAt((class_1936)world, state, pos);
        return pipe == null ? STATUS_VOIDED : pipe.tryInsert(world, state, pos, direction, fluids);
    }

    public static Optional<PipeFluids> tryExtract(class_3218 world, class_2338 pos, class_2350 direction) {
        if (!world.method_22340(pos)) {
            return Optional.empty();
        }
        class_2680 state = world.method_8320(pos);
        PipeInsertable pipe = PipeInsertable.getPipeInterableAt((class_1936)world, state, pos);
        return pipe == null ? Optional.empty() : pipe.tryExtract(world, state, pos, direction);
    }

    public record PipeFluids(FluidMound fluids, Impurities impurities, int temperature) {
        public static final PipeFluids EMPTY = new PipeFluids(FluidMound.of(), Impurities.EMPTY, 0);
        public static final Codec<PipeFluids> CODEC = RecordCodecBuilder.create(i -> i.group((App)FluidMound.CODEC.fieldOf("fluids").forGetter(PipeFluids::fluids), (App)Impurities.CODEC.optionalFieldOf("impurities", (Object)Impurities.EMPTY).forGetter(PipeFluids::impurities), (App)Codec.INT.fieldOf("temperature").forGetter(PipeFluids::temperature)).apply((Applicative)i, PipeFluids::of));
        public static final Codec<List<PipeFluids>> LIST_CODEC = class_5699.method_33817((Codec)CODEC.listOf(), CODEC).flatXmap(either -> (DataResult)EitherCompat.unwrap(either.mapBoth(DataResult::success, single -> DataResult.success(List.of(single)))), list -> DataResult.success((Object)Either.left((Object)list)));

        public PipeFluids {
            temperature = class_3532.method_15340((int)temperature, (int)0, (int)15);
        }

        public static PipeFluids of(ItemFluids fluids, Impurities impurities, int temperature) {
            return fluids.isEmpty() && temperature == 0 ? EMPTY : new PipeFluids(FluidMound.of(fluids), impurities, temperature);
        }

        public static PipeFluids of(FluidMound fluids, Impurities impurities, int temperature) {
            return fluids.isEmpty() && temperature == 0 ? EMPTY : new PipeFluids(fluids, impurities, temperature);
        }

        public boolean isEmpty() {
            return this.fluids.isEmpty();
        }

        public PipeFluids combine(PipeFluids fluids) {
            return PipeFluids.of(FluidMound.of(this.fluids()).addAll(fluids.fluids()), Impurities.combine(this.impurities(), fluids.impurities()), class_3532.method_48781((float)0.5f, (int)this.temperature(), (int)fluids.temperature()));
        }

        public PipeFluids withTemperature(int temperature) {
            return PipeFluids.of(FluidMound.of(this.fluids()), this.impurities(), temperature);
        }

        public PipeFluids withFluids(FluidMound fluids) {
            return PipeFluids.of(fluids, this.impurities(), this.temperature());
        }

        public FluidMound splitCondensate() {
            return this.fluids.split(i -> i.fluid().getCondensationTemperature() > this.temperature);
        }
    }
}

