/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block;

import ivorius.psychedelicraft.block.GlassTubeBlock;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.PipeInsertable;
import ivorius.psychedelicraft.block.PumpHeadBlock;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.recipe.FluidMound;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class PumpBlock
extends class_2318
implements PipeInsertable {
    public static final class_2746 POWERED = class_2741.field_12484;

    public PumpBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_10927, (Comparable)class_2350.field_11043)).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_10927, POWERED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)field_10927, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)field_10927)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)field_10927)));
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
        boolean powered = world.method_49803(pos);
        if (powered != (Boolean)state.method_11654((class_2769)POWERED)) {
            this.activate(state, world, pos, powered);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        boolean powered;
        if (!oldState.method_27852(state.method_26204()) && (powered = world.method_49803(pos))) {
            this.activate(state, world, pos, powered);
        }
    }

    private void activate(class_2680 state, class_1937 world, class_2338 pos, boolean powered) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_10927);
        class_2350 headFacing = PumpHeadBlock.getHeadFacing(facing);
        class_2338 headPos = pos.method_10093(headFacing);
        class_2680 headState = world.method_8320(headPos);
        if (headState.method_26212((class_1922)world, headPos) && !headState.method_27852(PSBlocks.PUMP_HEAD)) {
            return;
        }
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)));
        if (powered) {
            if (!headState.method_27852(PSBlocks.PUMP_HEAD)) {
                world.method_22352(headPos, true);
                class_2680 newHeadState = PumpBlock.method_9582((class_2680)headState, (class_2680)((class_2680)PSBlocks.PUMP_HEAD.method_9564().method_11657((class_2769)field_10927, (Comparable)headFacing)), (class_1936)world, (class_2338)headPos);
                world.method_8652(headPos, newHeadState, 2);
            }
        } else if (headState.method_27852(PSBlocks.PUMP_HEAD)) {
            world.method_8652(headPos, class_2246.field_10124.method_9564(), 2);
        }
        world.method_8396(null, pos, powered ? class_3417.field_15134 : class_3417.field_15228, class_3419.field_15245, 0.5f, world.field_9229.method_43057() * 0.25f + 0.6f);
        world.method_43276(powered ? class_5712.field_28174 : class_5712.field_28175, pos, class_5712.class_7397.method_43287((class_2680)state));
        if (!powered) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)world;
        @Nullable class_2338 inPos = PumpBlock.findInputPos((class_1936)world, pos.method_10093(facing));
        if (inPos == null) {
            return;
        }
        class_2680 inFluid = world.method_8320(inPos);
        if (inFluid.method_26227().method_15769()) {
            return;
        }
        class_2338 outPos = pos.method_10093(facing.method_10153());
        class_2680 outState = world.method_8320(outPos);
        outState.method_28500(GlassTubeBlock.IN).orElse(GlassTubeBlock.IODirection.NONE).getDirection().ifPresent(inDirection -> {
            if (inDirection == facing) {
                for (int i = 0; i < 10; ++i) {
                    PipeInsertable.tryInsert(sw, outPos, facing.method_10153(), PipeInsertable.PipeFluids.of(FluidMound.of(SimpleFluid.of(inFluid.method_26227().method_15772()).getDefaultStack(8100)), Impurities.EMPTY, 0));
                }
                class_2248 patt5264$temp = inFluid.method_26204();
                if (patt5264$temp instanceof class_2263) {
                    class_2263 drainable = (class_2263)patt5264$temp;
                    drainable.method_9700(null, (class_1936)world, inPos, inFluid);
                }
            }
        });
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)super.method_9605(ctx).method_11657((class_2769)field_10927, (Comparable)ctx.method_7715().method_10153());
    }

    @Override
    public boolean acceptsConnectionFrom(class_1936 world, class_2680 state, class_2338 pos, class_2680 neighborState, class_2338 neighborPos, class_2350 direction, boolean input) {
        return !input && direction == state.method_11654((class_2769)field_10927) && neighborState.method_26204() instanceof GlassTubeBlock;
    }

    @Nullable
    static class_2338 findInputPos(class_1936 world, class_2338 initial) {
        return PumpBlock.findInputPos(world, initial.method_25503(), new HashSet<class_2338>(), 10);
    }

    @Nullable
    static class_2338 findInputPos(class_1936 world, class_2338.class_2339 mutable, Set<class_2338> visited, int maxDepth) {
        class_2338 pos = mutable.method_10062();
        if (!visited.add(pos)) {
            return null;
        }
        class_3610 state = world.method_8316(pos);
        if (state.method_15769()) {
            return null;
        }
        if (state.method_15771()) {
            return pos;
        }
        class_2338 nearest = null;
        SimpleFluid main = SimpleFluid.of(state.method_15772());
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 p;
            class_3610 neighbor = world.method_8316((class_2338)mutable.method_10101((class_2382)pos).method_10098(dir));
            SimpleFluid fluid = SimpleFluid.of(neighbor.method_15772());
            if (fluid != main || (p = PumpBlock.findInputPos(world, mutable, visited, maxDepth - 1)) == null || nearest != null && !(pos.method_10262((class_2382)nearest) > pos.method_10262((class_2382)p))) continue;
            nearest = p;
        }
        if (nearest == null) {
            return PumpBlock.findInputPos(world, mutable.method_10098(class_2350.field_11033), visited, maxDepth - 1);
        }
        return nearest;
    }
}

