/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.block.entity;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.block.PSBlocks;
import ivorius.psychedelicraft.block.entity.BlockEntityWithInventory;
import ivorius.psychedelicraft.block.entity.PSBlockEntities;
import ivorius.psychedelicraft.recipe.DryingRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.screen.DryingTableScreenHandler;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_8786;

public class DryingTableBlockEntity
extends BlockEntityWithInventory {
    public static final int OUTPUT_SLOT_INDEX = 0;
    private static final int[] INPUT_SLOTS = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final int[] OUTPUT_SLOTS = new int[]{0};
    private float heat;
    private float dryingProgress;
    private long cookingTime;
    private Optional<class_2960> currentRecipe = Optional.empty();
    public final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> (int)(DryingTableBlockEntity.this.heat * 1000.0f);
                case 1 -> (int)DryingTableBlockEntity.this.dryingProgress;
                case 2 -> (int)DryingTableBlockEntity.this.cookingTime;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    DryingTableBlockEntity.this.heat = (float)value / 1000.0f;
                    break;
                }
                case 1: {
                    DryingTableBlockEntity.this.dryingProgress = value;
                    break;
                }
                case 2: {
                    DryingTableBlockEntity.this.cookingTime = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public static long getCookingTime(float recipeDifficulty, boolean ironTable) {
        return (long)(recipeDifficulty * (float)(ironTable ? (Integer)Psychedelicraft.getConfig().ironDryingTableTickDuration.get() : (Integer)Psychedelicraft.getConfig().dryingTableTickDuration.get()).intValue());
    }

    public DryingTableBlockEntity(class_2338 pos, class_2680 state) {
        super(PSBlockEntities.DRYING_TABLE, pos, state, 10);
    }

    public static void serverTick(class_3218 world, class_2338 pos, class_2680 state, DryingTableBlockEntity entity) {
        entity.tick(world);
    }

    public float getHeatRatio() {
        return this.heat;
    }

    public float getDryingProgress() {
        return this.cookingTime == 0L ? 0.0f : this.dryingProgress / (float)this.cookingTime;
    }

    private float calculateSunStrength() {
        float l = (float)this.field_11863.method_22339(this.field_11867) / 15.0f;
        float h = !this.field_11863.method_22347(this.field_11867) ? ((class_1959)this.field_11863.method_23753(this.field_11867).comp_349()).method_8712() * 0.75f + 0.25f : 0.0f;
        float sunStrength = class_3532.method_15363((float)(l * l * h * (l * l * h)), (float)0.0f, (float)1.0f);
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2680 neighbor;
            if (!this.field_11863.method_22347(this.field_11867.method_10093(dir)) || !((neighbor = this.field_11863.method_8320(this.field_11867.method_10079(dir, 2))).method_26204() instanceof class_2363) || !((Boolean)neighbor.method_11654((class_2769)class_2363.field_11105)).booleanValue() || neighbor.method_11654((class_2769)class_2363.field_11104) != dir.method_10153()) continue;
            sunStrength += neighbor.method_27852(class_2246.field_16333) ? 0.15f : (neighbor.method_27852(class_2246.field_16334) ? 0.125f : 0.1f);
            class_1937 class_19372 = this.field_11863;
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 sw = (class_3218)class_19372;
            if (this.field_11863.method_8409().method_43048(10) != 0) continue;
            sw.method_14199((class_2394)class_2398.field_11240, (double)(this.field_11867.method_10263() + dir.method_10148()) + this.field_11863.method_8409().method_43385(0.5, 0.25), (double)this.field_11867.method_10264() + this.field_11863.method_8409().method_43385(0.5, 0.5), (double)(this.field_11867.method_10260() + dir.method_10165()) + this.field_11863.method_8409().method_43385(0.5, 0.25), 1, 0.0, 0.0, 0.0, (double)0.01f);
        }
        return sunStrength;
    }

    public void tick(class_3218 world) {
        float oldProgress = this.dryingProgress;
        float oldHeat = this.heat;
        this.heat = this.calculateSunStrength();
        if (!(world.method_8430(1.0f) > 0.0f) || !world.method_8311(this.field_11867)) {
            if (this.currentRecipe.isPresent() && this.cookingTime > 0L) {
                this.dryingProgress += this.heat;
                int delta = (int)((1.0f - class_3532.method_15363((float)(this.dryingProgress / (float)this.cookingTime), (float)0.0f, (float)1.0f)) * 100.0f);
                if (delta == 0 || world.method_8510() % 30L == 0L) {
                    for (int i = 0; i < 5; ++i) {
                        world.method_14199((class_2394)class_2398.field_11251, (double)this.field_11867.method_10263() + world.method_8409().method_43385(0.5, 0.5), (double)((float)this.field_11867.method_10264() + 0.6f), (double)this.field_11867.method_10260() + world.method_8409().method_43385(0.5, 0.5), 2, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                if (this.dryingProgress >= (float)this.cookingTime) {
                    DryingRecipe.Input input = new DryingRecipe.Input(this.method_5438(0), this.getStacks().skip(1L).toList());
                    world.method_8433().method_42299(PSRecipes.DRYING_TYPE, (class_1263)input, (class_1937)world, this.currentRecipe.get()).ifPresent(recipe -> this.craft(world, (DryingRecipe)((class_8786)recipe.getSecond()).comp_1933(), input));
                    this.currentRecipe = Optional.empty();
                    this.dryingProgress = 0.0f;
                    this.cookingTime = 0L;
                    world.method_14178().method_14128(this.field_11867);
                }
            } else {
                this.dryingProgress = 0.0f;
            }
        }
        if (!class_3532.method_15347((float)oldProgress, (float)this.dryingProgress) || !class_3532.method_15347((float)oldHeat, (float)this.heat)) {
            this.method_5431();
        }
    }

    @Override
    public void method_5431() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sw = (class_3218)class_19372;
            sw.method_8433().method_8132(PSRecipes.DRYING_TYPE, (class_1263)new DryingRecipe.Input(this.method_5438(0), this.getStacks().skip(1L).toList()), (class_1937)sw).ifPresentOrElse(recipe -> {
                Optional<class_2960> recipeId = Optional.of(recipe.comp_1932());
                if (!recipeId.equals(this.currentRecipe)) {
                    this.dryingProgress = 0.0f;
                }
                this.currentRecipe = recipeId;
                this.cookingTime = DryingTableBlockEntity.getCookingTime(((DryingRecipe)recipe.comp_1933()).cookTime(), this.method_11010().method_27852(PSBlocks.IRON_DRYING_TABLE));
            }, () -> {
                this.currentRecipe = Optional.empty();
                this.cookingTime = 0L;
                this.dryingProgress = 0.0f;
            });
            this.heat = this.calculateSunStrength();
        }
        super.method_5431();
    }

    private void craft(class_3218 world, DryingRecipe recipe, DryingRecipe.Input input) {
        class_1799 result = recipe.craft(input, world.method_30349());
        this.method_5448();
        class_2371<class_1799> remainder = recipe.getRemainder(input);
        for (int i = 0; i < remainder.size(); ++i) {
            this.method_5447(i + 1, (class_1799)remainder.get(i));
        }
        if (!input.result().method_7960()) {
            result.method_7933(input.result().method_7947());
        }
        this.method_5447(0, result);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return super.method_5492(slot, stack, direction) && slot != 0 && this.method_5438(slot).method_7960();
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        return slot == 0;
    }

    public int[] method_5494(class_2350 direction) {
        return direction == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new DryingTableScreenHandler(syncId, playerInventory, this.propertyDelegate, (class_1263)this);
    }

    @Override
    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        this.currentRecipe.ifPresent(r -> compound.method_10582("currentRecipe", r.toString()));
        compound.method_10548("heatRatio", this.heat);
        compound.method_10544("cookingTime", this.cookingTime);
        compound.method_10548("dryingProgress", this.dryingProgress);
    }

    @Override
    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.currentRecipe = class_2960.method_29186((String)compound.method_10558("currentRecipe")).result();
        this.heat = compound.method_10583("heatRatio");
        this.cookingTime = compound.method_10537("cookingTime");
        this.dryingProgress = compound.method_10583("dryingProgress");
    }
}

