/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.client.render.effect;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.client.PsychedelicraftClient;
import ivorius.psychedelicraft.client.render.MeteorlogicalUtil;
import ivorius.psychedelicraft.client.render.RenderUtil;
import ivorius.psychedelicraft.client.render.effect.ScreenEffect;
import ivorius.psychedelicraft.client.render.shader.ShaderContext;
import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_1041;
import net.minecraft.class_1657;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class EnvironmentalScreenEffect
implements ScreenEffect {
    private static final class_2960 HURT_OVERLAY = Psychedelicraft.id("textures/environment/hurt_overlay.png");
    private float experiencedHealth = 5.0f;
    private int timeScreenWet;
    private boolean wasInWater;
    private boolean wasInRain;
    private float currentHeat;

    public float getHeatDistortion() {
        if (!((Boolean)PsychedelicraftClient.getConfig().doHeatDistortion.get()).booleanValue()) {
            return 0.0f;
        }
        return this.wasInWater ? 0.0f : class_3532.method_15363((float)((this.currentHeat - 1.0f) * 0.008f), (float)0.0f, (float)1.0f);
    }

    public float getWaterDistortion() {
        float peyote = ShaderContext.drug(DrugType.PEYOTE);
        float wetness = (Boolean)PsychedelicraftClient.getConfig().doWaterDistortion.get() != false && this.wasInWater ? 0.005125f : 0.0f;
        return Math.max(peyote * 0.173f, wetness);
    }

    public float getWaterScreenDistortion() {
        return (Boolean)PsychedelicraftClient.getConfig().waterOverlayEnabled.get() != false && this.timeScreenWet > 0 && !this.wasInWater ? Math.min(1.0f, (float)this.timeScreenWet / 80.0f) : 0.0f;
    }

    @Override
    public void update(float tickDelta) {
        float newHeat;
        class_746 entity = class_310.method_1551().field_1724;
        this.experiencedHealth = MathUtils.nearValue(this.experiencedHealth, entity.method_6032(), 0.01f, 0.01f);
        this.wasInWater = entity.method_37908().method_8316(class_2338.method_49638((class_2374)entity.method_33571())).method_15767(class_3486.field_15517);
        boolean bl = this.wasInRain = entity.method_37908().method_8430(tickDelta) > 0.0f && ((class_1959)entity.method_37908().method_23753(entity.method_24515()).comp_349()).method_48162(entity.method_24515()) == class_1959.class_1963.field_9382 && (double)entity.method_37908().method_8598(class_2902.class_2903.field_13197, entity.method_24515()).method_10264() <= entity.method_23318();
        if (((Boolean)PsychedelicraftClient.getConfig().waterOverlayEnabled.get()).booleanValue()) {
            --this.timeScreenWet;
            if (this.wasInWater) {
                this.timeScreenWet += 20;
            }
            if (this.wasInRain) {
                this.timeScreenWet += 4;
            }
            this.timeScreenWet = class_3532.method_15340((int)this.timeScreenWet, (int)0, (int)100);
        }
        class_2338 pos = entity.method_24515();
        float f = newHeat = this.wasInWater ? 0.0f : ((class_1959)entity.method_37908().method_23753(pos).comp_349()).method_8712();
        if (!entity.method_37908().method_8597().comp_643()) {
            newHeat *= MeteorlogicalUtil.getSunIntensity(entity.method_37908());
            float skyIntensity = MeteorlogicalUtil.getSkyLightIntensity(entity.method_37908(), class_2338.method_49638((class_2374)entity.method_33571()));
            newHeat *= Math.min(skyIntensity * skyIntensity * skyIntensity, 1.0f);
        } else {
            float multiplier = 0.0f;
            for (class_2338 p : class_2338.method_30512((class_2338)pos, (int)2, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
                multiplier += (float)Math.max(0, entity.method_37908().method_8314(class_1944.field_9282, p) - 11) / 4.0f;
            }
            newHeat *= class_3532.method_15363((float)multiplier, (float)0.5f, (float)1.0f);
        }
        this.currentHeat = MathUtils.nearValue(this.currentHeat, newHeat, 0.01f, newHeat > this.currentHeat ? 0.01f : 0.1f);
    }

    @Override
    public void render(class_332 context, class_1041 window, float tickDelta) {
        class_310 client = class_310.method_1551();
        @Nullable class_746 entity = client.field_1724;
        if (entity == null) {
            return;
        }
        DrugProperties properties = DrugProperties.of((class_1657)entity);
        float cardiacArrest = properties.getCardiacArrestProgress(tickDelta);
        float pulseStrength = properties.getMusicManager().getHeartbeatPulseStrength(tickDelta) + cardiacArrest;
        if (((Boolean)PsychedelicraftClient.getConfig().hurtOverlayEnabled.get()).booleanValue() && (entity.field_6235 > 0 && properties.getModifier(Drug.PAIN_SUPPRESSION) <= 1.0f || this.experiencedHealth < 5.0f || pulseStrength > 0.0f)) {
            float p1 = Math.max((float)entity.field_6235 / (float)entity.field_6254, pulseStrength);
            float p2 = (5.0f - this.experiencedHealth * (1.0f - pulseStrength)) / 6.0f;
            float p = class_3532.method_15363((float)(p1 > 0.0f ? p1 : (p2 > 0.0f ? p2 : 0.0f)), (float)0.0f, (float)1.0f);
            int color = class_5253.class_5254.method_48780((float)cardiacArrest, (int)-65536, (int)-16777216);
            RenderUtil.drawOverlay(context, HURT_OVERLAY, p, color, window.method_4486(), window.method_4502(), 0.0f, 0.0f, 1.0f, 1.0f, (int)((1.0f - p) * 40.0f));
        }
    }

    @Override
    public void close() {
    }
}

