/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.gui.WidgetConfig;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.compat.tia.FluidBoxWidget;
import ivorius.psychedelicraft.compat.tia.PSRecipe;
import ivorius.psychedelicraft.compat.tia.RecipeCategory;
import ivorius.psychedelicraft.compat.tia.RecipeUtil;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.MashingRecipe;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8786;

class MashingEmiRecipe
implements PSRecipe {
    private static final class_2960 TEXTURE = Psychedelicraft.id("textures/gui/wooden_vat.png");
    private static final TextureConfig IN_VAT = TextureConfig.builder().size(60, 44).texture(TEXTURE).uv(57, 15).build();
    private static final TextureConfig OUT_VAT = TextureConfig.builder().size(30, 20).texture(TEXTURE).uv(28, 10).textureSize(128, 128).build();
    private final class_8786<MashingRecipe> recipe;
    private final List<TlaIngredient> input;
    private final ItemFluids outputFluid;
    private final TlaStack output;
    private final List<ItemFluids> baseFluids;
    private final TlaIngredient fluidIngredient;

    public MashingEmiRecipe(class_8786<MashingRecipe> recipe) {
        this.recipe = recipe;
        this.input = RecipeUtil.grouped(((MashingRecipe)recipe.comp_1933()).method_8117().stream().map(TlaIngredient::ofIngredient)).toList();
        this.outputFluid = ((MashingRecipe)recipe.comp_1933()).result().ofAmount(729000);
        this.output = RecipeUtil.toTlaStack(this.outputFluid);
        this.baseFluids = RecipeUtil.getMatchingFluids(((MashingRecipe)recipe.comp_1933()).baseFluid(), 729000);
        this.fluidIngredient = TlaIngredient.join(this.baseFluids.stream().map(RecipeUtil::toIngredient).toList());
    }

    @Override
    public RecipeCategory getCategory() {
        return RecipeCategory.VAT;
    }

    public class_2960 getId() {
        return this.recipe.comp_1932();
    }

    public List<TlaIngredient> getInputs() {
        return this.input;
    }

    public List<TlaStack> getOutputs() {
        return List.of(this.output);
    }

    public List<TlaIngredient> getCatalysts() {
        return List.of(this.fluidIngredient);
    }

    public void buildGui(GuiBuilder widgets) {
        int x = 7;
        int y = 0;
        widgets.addArrow(60 + x, 21 + y, false).addTooltip(new class_2561[]{class_2561.method_43469((String)"gui.psychedelicraft.recipe.stewing_time", (Object[])new Object[]{((MashingRecipe)this.recipe.comp_1933()).stewTime()})});
        widgets.addAnimatedArrow(60 + x, 21 + y, 5000);
        FluidBoxWidget inBox = FluidBoxWidget.create(this.baseFluids, 729000, x, 17 + y, 60, 31, widgets);
        widgets.addTexture(IN_VAT, x, 5 + y);
        widgets.addSlot(this.fluidIngredient, 2, this.getCategory().getDisplayHeight() - 16 - 4).markCatalyst();
        FluidBoxWidget outBox = FluidBoxWidget.create(this.outputFluid, 729000, x += 85, 8 + (y += 15), 30, 16, widgets);
        outBox.addExclusion((WidgetConfig)widgets.addSlot(this.output, 6 + x, 8 + y).disableBackground().markOutput());
        widgets.addTexture(OUT_VAT, x, 5 + y);
        int ingredientsStackCount = this.input.size();
        int maxIngredientsWidth = 48;
        int maxIngredientsHeight = 32;
        int ingredientsLeft = 9 + (maxIngredientsWidth - Math.min(3, ingredientsStackCount) * 16) / 2;
        int ingredientsTop = 2 + (maxIngredientsHeight - ingredientsStackCount / 4 * 8) / 2;
        for (int i = 0; i < ingredientsStackCount; ++i) {
            int row = i / 3;
            int col = i % 3;
            inBox.addExclusion((WidgetConfig)widgets.addSlot(this.input.get(i), col * 16 + ingredientsLeft, row * 16 + ingredientsTop + col % 2 * 8).disableBackground().markInput());
        }
    }
}

