/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.compat.tia.Main;
import ivorius.psychedelicraft.compat.tia.PSRecipe;
import ivorius.psychedelicraft.compat.tia.RecipeCategory;
import ivorius.psychedelicraft.compat.tia.RecipeUtil;
import ivorius.psychedelicraft.item.PSItems;
import ivorius.psychedelicraft.recipe.HardeningRecipe;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8786;

class TrayEmiRecipe
implements PSRecipe {
    private final class_8786<HardeningRecipe> recipe;
    private final TlaIngredient base;
    private final List<TlaIngredient> impurities;
    private final List<TlaStack> output;

    public TrayEmiRecipe(class_8786<HardeningRecipe> recipe) {
        this.recipe = recipe;
        this.base = RecipeUtil.toIngredient(((HardeningRecipe)recipe.comp_1933()).coreFluid(), 1);
        this.impurities = ((HardeningRecipe)recipe.comp_1933()).solutions().stream().map(i -> {
            ((HardeningRecipe)recipe.comp_1933()).coreFluid();
            return RecipeUtil.toIngredient(i, 1);
        }).toList();
        this.output = List.of(TlaStack.of((class_1799)((HardeningRecipe)recipe.comp_1933()).method_8110(class_310.method_1551().field_1687.method_30349())));
    }

    @Override
    public RecipeCategory getCategory() {
        return RecipeCategory.TRAY;
    }

    public class_2960 getId() {
        return this.recipe.comp_1932();
    }

    public List<TlaIngredient> getInputs() {
        return List.of(this.base);
    }

    public List<TlaStack> getOutputs() {
        return this.output;
    }

    public List<TlaIngredient> getCatalysts() {
        return this.impurities;
    }

    public void buildGui(GuiBuilder widgets) {
        int y = 4;
        widgets.addSlot((TlaStack)TlaStack.of((class_1935)PSItems.BOTTLE), 10, y + 13).disableBackground();
        widgets.addSlot((TlaStack)TlaStack.of((class_1935)PSItems.BUNSEN_BURNER), 12, y + 23).disableBackground().markCatalyst();
        widgets.addArrow(30, y + 23, false);
        widgets.addAnimatedFlame(30, y + 23, 900);
        int ingredientsX = 70;
        if (this.impurities.isEmpty()) {
            widgets.addSlot(this.base, ingredientsX, y + 22).markInput();
        } else {
            widgets.addSlot(this.base, ingredientsX, y + 4).markInput();
            widgets.addTexture(TextureConfig.builder().texture(Main.WIDGETS).size(13, 13).uv(82, 0).build(), ingredientsX + 3, y + 24);
            int gridWidth = this.impurities.size() * 20;
            int gridLeft = ingredientsX + 10 - gridWidth / 2;
            for (int i = 0; i < this.impurities.size(); ++i) {
                widgets.addSlot(this.impurities.get(i), i % 3 * 18 + gridLeft, i / 3 * 18 + y + 40).markInput();
            }
        }
        widgets.addArrow(100, y + 23, false);
        widgets.addSlot(this.output.get(0), 170, y + 20).makeLarge().markOutput();
        widgets.addAnimatedArrow(130, y + 23, Math.max(1, ((HardeningRecipe)this.recipe.comp_1933()).hardeningTime()) * 900);
        widgets.addSlot((TlaStack)TlaStack.of((class_1935)PSItems.TRAY), 130, y + 23).disableBackground().markCatalyst();
    }
}

