/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.compat.tia;

import io.github.mattidragon.tlaapi.api.gui.GuiBuilder;
import io.github.mattidragon.tlaapi.api.gui.TextureConfig;
import io.github.mattidragon.tlaapi.api.plugin.PluginContext;
import io.github.mattidragon.tlaapi.api.recipe.TlaCategory;
import io.github.mattidragon.tlaapi.api.recipe.TlaIngredient;
import io.github.mattidragon.tlaapi.api.recipe.TlaRecipe;
import io.github.mattidragon.tlaapi.api.recipe.TlaStack;
import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.compat.tia.Main;
import ivorius.psychedelicraft.compat.tia.RecipeUtil;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.PSItems;
import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

class WorldInteractionPSRecipe
implements TlaRecipe {
    static final int PLUS_WIDTH = 13;
    static final int ARROW_WIDTH = 24;
    private final class_2960 id;
    private final List<TlaIngredient> left;
    private final List<TlaIngredient> right;
    private final List<TlaStack> outputs;
    private int leftSize = 1;
    private int rightSize = 1;
    private int outputSize = 1;
    private final TlaCategory category;

    public static void generate(TlaCategory category, PluginContext context) {
        List<class_6880.class_6883> customFluids = SimpleFluid.REGISTRY.method_40270().filter(entry -> ((SimpleFluid)entry.comp_349()).getPhysical().getStandingFluid().method_15774() == PSItems.FILLED_BUCKET).toList();
        List<class_2960> removedFluidInteractionRecipeIds = customFluids.stream().flatMap(entry -> entry.method_40230().stream()).map(class_5321::method_29177).map(WorldInteractionPSRecipe::bucketFillingId).toList();
        context.addGenerator(client -> customFluids.stream().map(fluid -> new WorldInteractionPSRecipe(category, WorldInteractionPSRecipe.recipeId("psy_bucket_filling", ((class_5321)fluid.method_40230().orElseThrow()).method_29177()), TlaStack.of((class_1935)class_1802.field_8550).asIngredient(), TlaIngredient.ofFluids(List.of(((SimpleFluid)fluid.comp_349()).getPhysical().getStandingFluid())), RecipeUtil.toTlaStack(class_1802.field_8550.method_7854(), ((SimpleFluid)fluid.comp_349()).getDefaultStack()))).toList());
        context.addGenerator(client -> List.of(new WorldInteractionPSRecipe(category, Psychedelicraft.id("morning_glory_flowers"), TlaStack.of((class_1935)PSItems.MORNING_GLORY_LATTICE).asIngredient(), TlaIngredient.ofItemTag((class_6862)ConventionalItemTags.SHEARS), (TlaStack)TlaStack.of((class_1935)PSItems.MORNING_GLORY)), new WorldInteractionPSRecipe(category, Psychedelicraft.id("juniper_berries"), TlaStack.of((class_1935)PSItems.FRUITING_JUNIPER_LEAVES).asIngredient(), TlaIngredient.ofItemTag((class_6862)ConventionalItemTags.SHEARS), (TlaStack)TlaStack.of((class_1935)PSItems.JUNIPER_BERRIES)), new WorldInteractionPSRecipe(category, Psychedelicraft.id("wine_grapes"), TlaStack.of((class_1935)PSItems.WINE_GRAPE_LATTICE).asIngredient(), TlaIngredient.ofItemTag((class_6862)ConventionalItemTags.SHEARS), (TlaStack)TlaStack.of((class_1935)PSItems.WINE_GRAPES))));
        context.removeRecipes(recipe -> removedFluidInteractionRecipeIds.contains(recipe.getId()));
    }

    public WorldInteractionPSRecipe(TlaCategory category, class_2960 id, TlaIngredient left, TlaIngredient right, TlaStack output) {
        this.category = category;
        this.id = id.method_45138("/");
        this.left = List.of(left);
        this.right = List.of(right);
        this.outputs = List.of(output);
        this.leftSize = this.left.size();
        this.rightSize = this.right.size();
        this.outputSize = this.outputs.size();
    }

    public TlaCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<TlaIngredient> getInputs() {
        return this.left;
    }

    public List<TlaIngredient> getCatalysts() {
        return this.right;
    }

    public List<TlaStack> getOutputs() {
        return this.outputs;
    }

    public void buildGui(GuiBuilder widgets) {
        TlaIngredient wi;
        int i;
        int lr = this.leftSize * 18;
        int ol = this.getCategory().getDisplayWidth() - this.outputSize * 18;
        int rl = (lr + ol) / 2 - this.rightSize * 9 - 4;
        int rr = rl + this.rightSize * 18;
        widgets.addTexture(TextureConfig.builder().texture(Main.WIDGETS).size(13, 13).uv(82, 0).build(), (lr + rl) / 2 - 6, 0);
        widgets.addArrow((rr + ol) / 2 - 12, 0, false);
        int yo = 0;
        for (i = 0; i < this.left.size(); ++i) {
            wi = this.left.get(i);
            widgets.addSlot(wi, i % this.leftSize * 18, yo + i / this.leftSize * 18).markInput();
        }
        yo = 0;
        for (i = 0; i < this.right.size(); ++i) {
            wi = this.right.get(i);
            widgets.addSlot(wi, rl + i % this.rightSize * 18, yo + i / this.rightSize * 18).markCatalyst();
        }
        yo = 0;
        for (i = 0; i < this.outputs.size(); ++i) {
            wi = this.outputs.get(i);
            widgets.addSlot((TlaStack)wi, ol + i % this.outputSize * 18, yo + i / this.outputSize * 18).markOutput();
        }
    }

    static class_2960 bucketFillingId(class_2960 id) {
        return WorldInteractionPSRecipe.recipeId("bucket_filling", id);
    }

    static class_2960 recipeId(String type, class_2960 id) {
        return class_2960.method_43902((String)"emi", (String)("/emi/" + type + "/" + WorldInteractionPSRecipe.subId(id)));
    }

    static String subId(class_2960 id) {
        return id.method_12836() + "/" + id.method_12832();
    }
}

