/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.config;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public interface BiomeSelector {
    public static final Predicate<BiomeSelectionContext> ALL = BiomeSelectors.all();
    public static final Predicate<BiomeSelectionContext> NONE = ctx -> false;
    public static final Predicate<BiomeSelectionContext> COLD = ctx -> ctx.getBiome().method_8712() < 0.15f;
    public static final Predicate<BiomeSelectionContext> DRY = ctx -> !ctx.getBiome().method_48163();

    public static Predicate<BiomeSelectionContext> compile(List<String> included, List<String> excluded, Predicate<BiomeSelectionContext> dynamicInclusion) {
        Predicate<BiomeSelectionContext> include = BiomeSelector.compile(included, NONE, Stream::anyMatch).or(dynamicInclusion);
        Predicate<BiomeSelectionContext> exclude = BiomeSelector.compile(excluded, ALL, Stream::noneMatch);
        return include.and(exclude);
    }

    public static Predicate<BiomeSelectionContext> compile(List<String> predicates, Predicate<BiomeSelectionContext> fallback, BiPredicate<Stream<Predicate<BiomeSelectionContext>>, Predicate<Predicate<BiomeSelectionContext>>> combiner) {
        if (predicates == null || predicates.isEmpty()) {
            return fallback;
        }
        List<Predicate> selectors = predicates.stream().map(BiomeSelector::compile).toList();
        if (selectors.size() == 1) {
            return selectors.get(0);
        }
        return ctx -> combiner.test(selectors.stream(), a -> a.test(ctx));
    }

    public static Predicate<BiomeSelectionContext> compile(String selector) {
        if (selector.startsWith("#")) {
            return BiomeSelectors.tag((class_6862)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(selector.substring(1))));
        }
        return BiomeSelector.ofId(new class_2960(selector));
    }

    public static Predicate<BiomeSelectionContext> ofId(class_2960 tagId) {
        return ctx -> ctx.getBiomeRegistryEntry().method_40226(tagId);
    }
}

