/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.datagen.providers.recipe;

import ivorius.psychedelicraft.datagen.providers.recipe.FluidRecipeJsonBuilder;
import ivorius.psychedelicraft.datagen.providers.recipe.RecipeJsonBuilderCompat;
import ivorius.psychedelicraft.fluid.SimpleFluid;
import ivorius.psychedelicraft.item.component.Impurities;
import ivorius.psychedelicraft.item.component.ItemFluids;
import ivorius.psychedelicraft.recipe.BunsenBurnerRecipe;
import ivorius.psychedelicraft.recipe.PSRecipes;
import ivorius.psychedelicraft.recipe.ReactingRecipe;
import ivorius.psychedelicraft.recipe.ingredient.FluidIngredient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class ReactingRecipeJsonBuilder
extends class_7798
implements FluidRecipeJsonBuilder {
    private final BunsenBurnerRecipe.ReactionType category;
    private final Map<String, class_175<?>> criterions = new LinkedHashMap();
    @Nullable
    private String group;
    private ItemFluids output;
    @Nullable
    private Impurities.Impurity impurity;
    private class_1792 byProduct = class_1802.field_8162;
    private int stewTime;
    private final class_2371<FluidIngredient> inputFluids = class_2371.method_10211();
    private final class_2371<class_1856> inputItems = class_2371.method_10211();

    private ReactingRecipeJsonBuilder(BunsenBurnerRecipe.ReactionType category, ItemFluids output) {
        this.category = category;
        this.output = output;
    }

    public static ReactingRecipeJsonBuilder create(BunsenBurnerRecipe.ReactionType category, ItemFluids output) {
        return new ReactingRecipeJsonBuilder(category, output);
    }

    public ReactingRecipeJsonBuilder byProduct(class_1935 item) {
        this.byProduct = item.method_8389();
        return this;
    }

    public ReactingRecipeJsonBuilder impurity(Impurities.Impurity impurity) {
        this.impurity = impurity;
        return this;
    }

    public ReactingRecipeJsonBuilder input(SimpleFluid fluid) {
        return this.input(FluidIngredient.builder().fluid(fluid).build());
    }

    public ReactingRecipeJsonBuilder input(FluidIngredient fluid) {
        this.inputFluids.add((Object)fluid);
        return this;
    }

    public ReactingRecipeJsonBuilder input(class_6862<class_1792> item) {
        return this.input(class_1856.method_8106(item));
    }

    public ReactingRecipeJsonBuilder input(class_1935 item) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public ReactingRecipeJsonBuilder input(class_1856 ingredient) {
        this.inputItems.add((Object)ingredient);
        return this;
    }

    public ReactingRecipeJsonBuilder stewTime(int stewTime) {
        this.stewTime = stewTime;
        return this;
    }

    public ReactingRecipeJsonBuilder criterion(String name, class_175<?> criterion) {
        this.criterions.put(name, criterion);
        return this;
    }

    public ReactingRecipeJsonBuilder group(String group) {
        this.group = group;
        return this;
    }

    @Override
    public ItemFluids getOutputFluids() {
        return this.output;
    }

    public void method_17972(class_8790 exporter, class_2960 recipeId) {
        recipeId = recipeId.method_48331("_from_reacting");
        this.validate(recipeId);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        this.criterions.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        exporter.method_53819(RecipeJsonBuilderCompat.createProvider(recipeId, PSRecipes.REACTING, new ReactingRecipe(this.category, Objects.requireNonNullElse(this.group, ""), class_7710.field_40251, new ReactingRecipe.Result(this.output, new class_1799((class_1935)this.byProduct), Optional.ofNullable(this.impurity)), new ReactingRecipe.Ingredients(this.inputFluids, this.inputItems), this.stewTime), builder.method_695(recipeId.method_45138("recipes/" + class_7800.field_40641.method_46203() + "/"))));
    }

    private void validate(class_2960 recipeId) {
        if (this.criterions.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }
}

