/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import ivorius.psychedelicraft.entity.drug.Drug;
import ivorius.psychedelicraft.entity.drug.DrugAttributeFunctions;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.joml.Vector4f;

public record Attribute(String name, float initial, float fallback, Combiner combiner) implements DrugAttributeFunctions.Func
{
    public Attribute(String name, float initial, Combiner combiner) {
        this(name, initial, initial, combiner);
    }

    public float get(DrugProperties properties) {
        return this.get(this.initial, properties);
    }

    public float get(float value, DrugProperties properties) {
        for (Drug drug : properties.getAllDrugs()) {
            DrugAttributeFunctions.Func func = drug.getType().functions().get(this);
            value = this.combiner.combine(value, func.apply((float)drug.getActiveValue(), drug.getTicksActive()));
        }
        return value;
    }

    public static Function<DrugProperties, Vector4f> createColorModification(BiConsumer<Drug, Vector4f> modifier) {
        Vector4f initial = new Vector4f(1.0f, 1.0f, 1.0f, 0.0f);
        return properties -> {
            initial.set(1.0f, 1.0f, 1.0f, 0.0f);
            for (Drug drug : properties.getAllDrugs()) {
                modifier.accept(drug, initial);
            }
            return initial;
        };
    }

    @Override
    public float apply(float strength, int duration) {
        return this.fallback;
    }

    public static interface Combiner {
        public static final Combiner MUL = (a, b) -> a * b;
        public static final Combiner SUM = (a, b) -> a + b;
        public static final Combiner INVERSE_MUL = (a, b) -> a + (1.0f - a) * b;

        public float combine(float var1, float var2);
    }
}

