/*
 * Decompiled with CFR 0.152.
 */
package ivorius.psychedelicraft.entity.drug;

import ivorius.psychedelicraft.Psychedelicraft;
import ivorius.psychedelicraft.config.MessageDistortion;
import ivorius.psychedelicraft.entity.drug.DrugProperties;
import ivorius.psychedelicraft.entity.drug.DrugType;
import ivorius.psychedelicraft.util.MathUtils;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_5819;

public class MessageDistorter {
    public static final MessageDistorter INSTANCE = new MessageDistorter();

    public String distortIncomingMessage(class_1657 player, String message) {
        if (player == null || !((MessageDistortion)((Object)Psychedelicraft.getConfig().messageDistortion.get())).incoming()) {
            return message;
        }
        return this.distortMessage(DrugProperties.of(player), message);
    }

    public String distortOutgoingMessage(class_1657 player, String message) {
        if (player == null || !((MessageDistortion)((Object)Psychedelicraft.getConfig().messageDistortion.get())).outgoing()) {
            return message;
        }
        if (message.indexOf("/") == 0) {
            return message;
        }
        return this.distortMessage(DrugProperties.of(player), message);
    }

    private String distortMessage(DrugProperties properties, String message) {
        float alcohol = Math.min(properties.getDrugValue(DrugType.ALCOHOL) + properties.getDrugValue(DrugType.KAVA), 1.0f);
        float zero = properties.getDrugValue(DrugType.ZERO);
        float cannabis = properties.getDrugValue(DrugType.CANNABIS);
        if (alcohol > 0.0f || zero > 0.0f || cannabis > 0.0f) {
            return this.distortMessage(message, properties.asEntity().method_6051(), alcohol, zero, cannabis);
        }
        return message;
    }

    private String getRandomTranslation(String keyBeggining, class_5819 random) {
        int i = 0;
        while (class_1074.method_4663((String)(keyBeggining + i))) {
            ++i;
        }
        return i < 1 ? keyBeggining + i : class_1074.method_4662((String)(keyBeggining + random.method_43048(i)), (Object[])new Object[0]);
    }

    public String distortMessage(String message, class_5819 random, float alcohol, float zero, float cannabis) {
        StringBuilder builder = new StringBuilder();
        float randomCaseChance = MathUtils.project(alcohol, 0.3f, 1.0f) * 0.06f + MathUtils.project(zero, 0.0f, 0.3f);
        float randomLetterChance = MathUtils.project(alcohol, 0.5f, 1.0f) * 0.015f;
        float sToShChance = MathUtils.project(alcohol, 0.2f, 0.6f);
        float longShChance = alcohol * 0.8f;
        float hicChance = MathUtils.project(alcohol, 0.5f, 1.0f) * 0.04f;
        float rewindChance = MathUtils.project(alcohol, 0.4f, 0.9f) * 0.03f;
        float longCharChance = MathUtils.project(alcohol, 0.3f, 1.0f) * 0.025f;
        float oneZeroChance = MathUtils.project(zero, 0.6f, 0.95f);
        float randomCharChance = MathUtils.project(zero, 0.2f, 0.95f);
        float fillerWordChance = MathUtils.project(cannabis, 0.2f, 0.95f) * 0.1f;
        float startFillerWordChance = MathUtils.project(cannabis, 0.2f, 0.95f) * 0.7f;
        boolean wasPoint = true;
        for (int i = 0; i < message.length(); ++i) {
            char origChar;
            char curChar = origChar = message.charAt(i);
            if (random.method_43057() < oneZeroChance) {
                curChar = random.method_43056() ? (char)'0' : '1';
            } else if (random.method_43057() < randomCharChance) {
                curChar = (char)(32 + random.method_43048(95));
            } else if (random.method_43057() < randomLetterChance) {
                curChar = (char)((random.method_43056() ? 97 : 65) + random.method_43048(26));
            } else if (random.method_43057() < randomCaseChance && random.method_43056()) {
                curChar = Character.isUpperCase(curChar) ? Character.toLowerCase(curChar) : Character.toUpperCase(curChar);
            }
            if ((curChar == 's' || curChar == 'S') && random.method_43057() < sToShChance) {
                builder.append(curChar).append(random.method_43057() < longShChance ? "hh" : "h");
            } else if (curChar == ' ' && random.method_43057() < fillerWordChance) {
                builder.append(this.getRandomTranslation("distortion.psychedelicraft.filler_words.", random));
            } else if (wasPoint && random.method_43057() < startFillerWordChance) {
                builder.append(this.getRandomTranslation("distortion.psychedelicraft.start_filler_words.", random)).append(curChar);
            } else {
                builder.append(curChar);
            }
            wasPoint = false;
            if (random.method_43057() < longCharChance) {
                float moreChance = 1.2f;
                do {
                    builder.append(curChar);
                } while (random.method_43057() < (moreChance *= 0.5f));
            }
            if (random.method_43057() < hicChance) {
                builder.append(this.getRandomTranslation("distortion.psychedelicraft.hics.", random));
            }
            if (!(random.method_43057() < rewindChance)) continue;
            builder.append("... ");
            int wordsRewind = random.method_43048(5) + 1;
            for (int j = 0; j < wordsRewind; ++j) {
                i = message.lastIndexOf(" ", i - 1);
            }
            if (i >= 0) continue;
            i = 0;
        }
        return builder.toString();
    }
}

